<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Models\SubCard;
use App\Models\Button;

class CreateDefaultButtons extends Command
{
    protected $signature = 'buttons:create-defaults';
    protected $description = 'Create 10 default buttons for users and subcards';

    protected array $defaultButtons = [
        ['title' => 'Add to Contact', 'type' => 'vcf'],
        ['title' => 'How may I help?', 'type' => 'help'],
        ['title' => 'Exchange Contacts', 'type' => 'exchange'],
        ['title' => 'Send your feedback', 'type' => 'feedback'],
        ['title' => 'My Bio', 'type' => 'bio'],
        ['title' => 'Shop', 'type' => 'shop'],
        ['title' => 'Services', 'type' => 'services'],
        ['title' => 'Events', 'type' => 'events'],
        // ['title' => 'Sales', 'type' => 'sales'],
        // ['title' => 'Meet the Team', 'type' => 'team'],
        ['title' => 'Driving Directions', 'type' => 'driving'],
        ['title' => 'Zoom Replays', 'type' => 'zoom_replay'],
        ['title' => 'Testimonials', 'type' => 'reviews'],
        ['title' => 'Trusted Network', 'type' => 'trusted_network'],
        ['title' => 'Payment Links', 'type' => 'payments'],
    ];

    public function handle()
    {
        $this->info('Creating default buttons for all users...');

        foreach (User::cursor() as $user) {
            foreach ($this->defaultButtons as $button) {
                Button::firstOrCreate(
                    [
                        'user_id' => $user->id,
                        'type'    => $button['type'],
                        'page_id' => null,
                    ],
                    [
                        'title' => $button['title'],
                        'view'  => 'links',
                        'link'  => '',
                    ]
                );
            }
        }

        $this->info('Creating default buttons for all subcards...');

        foreach (SubCard::cursor() as $subcard) {
            foreach ($this->defaultButtons as $button) {
                Button::firstOrCreate(
                    [
                        'user_id' => $subcard->user_id,
                        'type'    => $button['type'],
                        'page_id' => $subcard->id,
                    ],
                    [
                        'title' => $button['title'],
                        'view'  => 'links',
                        'link'  => '',
                    ]
                );
            }
        }

        $this->info('Default buttons created successfully.');
    }
}
