<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;

class CreateFilamentAdmin extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'admin:create {username} {email} {password}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Creates a new active admin account to be used for accessing the admin dashboard';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $username = $this->argument('username');
        $email = $this->argument('email');
        $password = $this->argument('password');

        User::create([
            'username' => $username,
            'email' => $email,
            'password' => bcrypt($password),
            'is_admin' => 1
        ]);

        $this->info('Admin account successfully created! Username: ' . $username . ' Email: ' . $email);
    }
}
