<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Laravel\Cashier\Subscription;

class DowngradeExpiredTrials extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'trials:downgrade-expired';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Downgrades a user on trial after trial expires';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $expiredSubscriptions = Subscription::whereNotNull('trial_ends_at')
            ->where('trial_ends_at', '<=', now())
            // ->where('ends_at', null) // still active but trial ended
            ->whereIn('stripe_status', ['trialing', 'canceled', 'incomplete', 'incomplete_expired'])
            ->get();

        $count = 0;

        foreach ($expiredSubscriptions as $subscription) {
            $user = $subscription->owner;

            // if ($user && $user->user_type !== 'Free') {
            if ($user && $user->user_type !== 'Free' && !$subscription->hasIncompletePayment()) {
                $user->update([
                    'user_type' => 'Free',
                ]);

                $subscription->cancelNow(); // optional: end it immediately
                $count++;
            }
        }

        logger()->info('Expired trial users downgraded.');
    }
}
