<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;
use App\Settings\CardDefaultsSetting;
use Filament\Pages\SettingsPage;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Forms\Components\FileUpload;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use Illuminate\Support\Str;

// class CardDefaultContents extends Page
class CardDefaultContents extends SettingsPage
{
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static ?string $title = 'Card Default Contents';
    protected static ?string $navigationGroup = 'Settings';
    protected static ?string $navigationLabel = 'Card Default Contents';
    protected static ?string $slug = 'card-default-contents';
    protected static ?int $navigationSort = 8;

    protected static string $settings = CardDefaultsSetting::class;

    // protected static string $view = 'filament.pages.card-default-contents';

    public function form(Form $form): Form
    {
        $settings = app(CardDefaultsSetting::class);
        $width = $settings->ad_banner_w;
        $height = $settings->ad_banner_h;
        $aspectRatio = "{$width}:{$height}";

        return $form
            ->schema([

                Forms\Components\Section::make('Community')
                    ->description("This is optional. Community link added here will be added to the newly created (main) cards.")
                    ->schema([
                        // Forms\Components\Toggle::make('menu_enabled')
                        //     ->label('Enable Menu'),

                        Forms\Components\Repeater::make('community_links')
                            ->label('Community')
                            ->schema([

                                Forms\Components\Select::make('type')
                                    ->required()
                                    ->options([
                                        'fb_community' => 'Facebook Community',
                                        'whatsapp_community' => 'WhatsApp Community',
                                        'discord_community' => 'Discord Community',
                                        'telegram_community' => 'Telegram Community',
                                    ]),

                                Forms\Components\TextInput::make('title')
                                    ->label('Title')
                                    ->required(),

                                Forms\Components\TextInput::make('link')
                                    ->label('Link')
                                    ->required()
                                    ->url()
                                    ->placeholder('https://example.com'),

                            ])
                            ->reorderable(),
                        // ->collapsed(),
                        // ->visible(fn($get) => $get('menu_enabled')),
                    ]),


                Forms\Components\Section::make('Ads')
                    ->description("This is optional. Ads added here can be added on the registration process and will be added on the FREE cards. Free cards has the option to edit its link.")
                    ->schema([
                        Forms\Components\Toggle::make('default_ads_enabled')
                            ->label('Add on Registration'),

                        Forms\Components\TextInput::make('ads_heading')
                            ->label('Heading')
                            ->helperText('Heading added here will be displayed on the registration form.'),

                        Forms\Components\TextInput::make('ads_description')
                            ->label('Description')
                            ->helperText('Description added here will be displayed on the registration form below the heading.'),

                        Forms\Components\Repeater::make('ad_items')
                            ->label('Default Free Ads')
                            ->schema([
                                FileUpload::make('image')
                                    ->label("Upload Ad Banner ({$width}x{$height})")
                                    ->placeholder('Upload Ad Banner')
                                    ->directory('ads')
                                    ->disk('public')
                                    ->image()
                                    ->required()
                                    ->imageEditor()
                                    ->imageCropAspectRatio($aspectRatio) // This sets the default crop shape
                                    ->imageEditorAspectRatios([$aspectRatio]) // Only allow this one crop shape
                                    ->imageResizeMode('cover') // Resize after crop
                                    ->imageResizeTargetWidth($width)
                                    ->imageResizeTargetHeight($height)
                                    ->columnSpanFull()
                                    ->getUploadedFileNameForStorageUsing(
                                        fn(TemporaryUploadedFile $file): string =>
                                        (string) Str::random(40) . '.' . $file->getClientOriginalExtension()
                                    ),

                                Forms\Components\TextInput::make('caption')->label('Ad Title')
                                    ->required(),

                                // Forms\Components\TextInput::make('title')
                                //     ->required(),

                                Forms\Components\Select::make('position')
                                    ->required()
                                    ->label('Position')
                                    ->columnSpanFull()
                                    ->options([
                                        'top' => 'Top',
                                        'bottom' => 'Bottom',
                                    ]),
                                Forms\Components\Toggle::make('is_active')
                                    ->label('Active Ad')
                                    ->default(true)
                                    ->required(),

                            ])
                            ->reorderable(),
                    ]),


            ]);
    }
}
