<?php

namespace App\Filament\Pages;

use App\Settings\CardDefaultsSetting;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Forms\Components\RichEditor;
use Filament\Pages\SettingsPage;
use Filament\Forms\Components\FileUpload;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use Illuminate\Support\Str;

class ProductsPage extends SettingsPage
{
    protected static ?string $navigationIcon = 'heroicon-o-shopping-bag';
    protected static ?string $title = 'Products';
    protected static ?string $navigationGroup = 'Settings';
    protected static ?string $navigationLabel = 'Subscription Products';
    protected static ?int $navigationSort = 8;

    protected static string $settings = CardDefaultsSetting::class;

    public function form(Form $form): Form
    {
        $settings = app(CardDefaultsSetting::class);
        return $form
            ->schema([

                Forms\Components\Section::make('Membership Subscription Terminologies')
                    ->description("Changes here will be visible on the subscription items when updating and overall card.")
                    ->schema([
                        Forms\Components\TextInput::make('term_basic')
                            ->label('Basic Card')
                            ->required(),

                        Forms\Components\TextInput::make('term_gold')
                            ->label('Gold Card')
                            ->required(),

                        Forms\Components\TextInput::make('term_platinum')
                            ->label('Platinum Card')
                            ->required(),

                    ]),

                Forms\Components\Section::make('Membership Subscription Description/Tiers')
                    ->description("Changes here will be visible on the subscription items when updating and overall card.")
                    ->schema([
                        RichEditor::make('term_description_basic')
                            ->label($settings->term_basic . ' Card')
                            ->required(),

                        RichEditor::make('term_description_gold')
                            ->label($settings->term_gold . ' Card')
                            ->required(),

                        RichEditor::make('term_description_platinum')
                            ->label($settings->term_platinum . ' Card')
                            ->required(),

                    ]),

                Forms\Components\Section::make('Test Mode')
                    ->description('Turn ON when testing.')
                    ->schema([
                        Forms\Components\Toggle::make('test_mode')
                            ->label('Test Mode')
                    ]),

                Forms\Components\Section::make('Prices ID Test Mode (Automatic Capture)')
                    ->description("Don't change. For the developer only.")
                    ->schema([
                        Forms\Components\TextInput::make('test_basic_monthly')
                            ->label($settings->term_basic . ' Card Monthly')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('test_basic_yearly')
                            ->label($settings->term_basic . ' Card Yearly')
                            ->required()
                            ->maxLength(255),

                        Forms\Components\TextInput::make('test_gold_monthly')
                            ->label($settings->term_gold . ' Card Monthly')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('test_gold_yearly')
                            ->label($settings->term_gold . ' Card Yearly')
                            ->required()
                            ->maxLength(255),

                        Forms\Components\TextInput::make('test_platinum_monthly')
                            ->label($settings->term_platinum . ' Card Monthly')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('test_platinum_yearly')
                            ->label($settings->term_platinum . ' Card Yearly')
                            ->required()
                            ->maxLength(255),
                    ]),

                Forms\Components\Section::make('Prices ID Live Mode (Automatic Capture)')
                    ->description("Don't change. For the developer only.")
                    ->schema([
                        Forms\Components\TextInput::make('live_basic_monthly')
                            ->label($settings->term_basic . ' Card Monthly')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('live_basic_yearly')
                            ->label($settings->term_basic . ' Card Yearly')
                            ->required()
                            ->maxLength(255),

                        Forms\Components\TextInput::make('live_gold_monthly')
                            ->label($settings->term_gold . ' Card Monthly')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('live_gold_yearly')
                            ->label($settings->term_gold . ' Card Yearly')
                            ->required()
                            ->maxLength(255),

                        Forms\Components\TextInput::make('live_platinum_monthly')
                            ->label($settings->term_platinum . ' Card Monthly')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('live_platinum_yearly')
                            ->label($settings->term_platinum . ' Card Yearly')
                            ->required()
                            ->maxLength(255),
                    ]),


                Forms\Components\Section::make('Subscription Prices for Manual Capture')
                    ->schema([
                        Forms\Components\TextInput::make('manual_basic_card_link')
                            ->label($settings->term_basic . ' Card (Annual)')
                            ->required()
                            ->maxLength(255),

                        Forms\Components\TextInput::make('manual_basic_card_monthly_link')
                            ->label($settings->term_basic . ' Card (Monthly)')
                            ->maxLength(255),

                        Forms\Components\TextInput::make('manual_gold_card_link')
                            ->label($settings->term_gold . ' Card (Annual)')
                            ->required()
                            ->maxLength(255),

                        Forms\Components\TextInput::make('manual_gold_card_monthly_link')
                            ->label($settings->term_gold . ' Card (Monthly)')
                            ->maxLength(255),

                        Forms\Components\TextInput::make('manual_platinum_card_link')
                            ->label($settings->term_platinum . ' Card (Annual)')
                            ->required()
                            ->maxLength(255),

                        Forms\Components\TextInput::make('manual_platinum_card_monthly_link')
                            ->label($settings->term_platinum . ' Card (Monthly)')
                            ->maxLength(255),
                    ]),

                Forms\Components\Section::make('Prices used for computation')
                    ->description("Don't change. For the developer only.")
                    ->schema([
                        Forms\Components\TextInput::make('price_basic_monthly')
                            ->label($settings->term_basic . ' Card Monthly')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('price_basic_yearly')
                            ->label($settings->term_basic . ' Card Yearly')
                            ->required()
                            ->maxLength(255),

                        Forms\Components\TextInput::make('price_gold_monthly')
                            ->label($settings->term_gold . ' Card Monthly')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('price_gold_yearly')
                            ->label($settings->term_gold . ' Card Yearly')
                            ->required()
                            ->maxLength(255),

                        Forms\Components\TextInput::make('price_platinum_monthly')
                            ->label($settings->term_platinum . ' Card Monthly')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('price_platinum_yearly')
                            ->label($settings->term_platinum . ' Card Yearly')
                            ->required()
                            ->maxLength(255),
                    ]),


                Forms\Components\Section::make('Partnership Description/Tiers')
                    ->description("Changes here will be visible on the partnership items when updating and overall card.")
                    ->schema([
                        RichEditor::make('term_description_junior_partner')
                            ->label('Junior Partnership')
                            ->required(),

                        RichEditor::make('term_description_senior_partner')
                            ->label('Senior Partnership')
                            ->required(),
                    ]),

                Forms\Components\Section::make('Partnership Prices for Manual Capture')
                    ->schema([
                        Forms\Components\TextInput::make('manual_junior_partnership_link')
                            ->label('Junior Partnership Payment Link')
                            ->required(),

                        Forms\Components\TextInput::make('manual_senior_partnership_link')
                            ->label('Senior Partnership Payment Link')
                            ->required(),
                    ]),


            ]);
    }
}
