<?php

namespace App\Filament\Resources\AdResource\Widgets;

use Carbon\Carbon;
use App\Models\Analytics;
use App\Models\Ad;
use Filament\Widgets\ChartWidget;
use Flowframe\Trend\Trend;
use Flowframe\Trend\TrendValue;

class AdminAdAnalyticsOneWeek extends ChartWidget
{
    protected static ?string $heading = 'Overall Ad clicks (Last 7 Days)';
    protected static string $color = 'success';

    // protected function getData(): array
    // {
    //     $adIds = \App\Models\Ad::where('is_active', true)
    //         ->where('display_in', 'Free')
    //         ->pluck('id');

    //     $data = Trend::query(
    //         Analytics::where('type', 'ad_click')
    //             ->whereIn('ad_id', $adIds)
    //     )
    //         ->dateColumn('clicked_at')
    //         ->between(
    //             start: now()->subDays(6),
    //             end: now(),
    //         )
    //         ->perDay()
    //         ->count();

    //     return [

    //         'datasets' => [
    //             [
    //                 'label' => 'Ad clicks per month',
    //                 'data' => $data->map(fn(TrendValue $value) => $value->aggregate),
    //             ],
    //         ],
    //         'labels' => $data->map(fn(TrendValue $value) => Carbon::parse($value->date)->format('M Y')),
    //     ];
    // }

    protected function getData(): array
    {
        $adIds = Ad::where('is_active', true)
            ->where('display_in', 'Free')
            ->pluck('id');

        $data = Trend::query(
            Analytics::where('type', 'ad_click')
                ->whereIn('ad_id', $adIds)
        )
            ->dateColumn('clicked_at')
            ->between(
                start: now()->subDays(6),
                end: now(),
            )
            ->perDay()
            ->count();

        return [
            'datasets' => [
                [
                    'label' => 'Ad clicks per day',
                    'data' => $data->map(fn(TrendValue $value) => $value->aggregate),
                ],
            ],
            'labels' => $data->map(fn(TrendValue $value) => Carbon::parse($value->date)->format('D')), // e.g., Mon, Tue
        ];
    }

    protected function getType(): string
    {
        return 'line';
    }
}
