<?php

namespace App\Filament\Resources;

use App\Filament\Resources\FormSubmissionResource\Pages;
use App\Models\FormSubmission;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Carbon\Carbon;
use Filament\Infolists\Infolist;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Components;
use Illuminate\Support\HtmlString;

class FormSubmissionResource extends Resource
{
    protected static ?string $model = FormSubmission::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'Forms';

    protected static ?string $navigationLabel = 'Form Submissions';

    protected static ?string $modelLabel = 'Form Submissions';

    protected static ?int $navigationSort = 7;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->modifyQueryUsing(
                fn(Builder $query) =>
                $query->orderBy('created_at', 'desc')
            )
            ->columns([
                Tables\Columns\TextColumn::make('firstname')
                    ->label('Client')
                    ->formatStateUsing(
                        fn($state, $record) =>
                        "{$record->firstname} {$record->lastname}"
                    ),

                Tables\Columns\TextColumn::make('firstname')
                    ->label('Client')
                    ->formatStateUsing(
                        fn($state, $record) =>
                        "{$record->firstname} {$record->lastname}"
                    ),

                Tables\Columns\TextColumn::make('form.title')
                    ->label('Form'),

                Tables\Columns\TextColumn::make('created_at')
                    ->label('Submitted')
                    ->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y')),
            ])
            ->filters([
                //
            ])
            ->actions([
                // Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }


    public static function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                Components\Section::make('Form Details')
                    ->schema([
                        TextEntry::make('form.title')
                            ->label(new HtmlString('<strong>Form</strong>')),

                        TextEntry::make('firstname')
                            ->label(new HtmlString('<strong>Full Name</strong>'))
                            ->formatStateUsing(fn($state, $record) => $record->firstname . ' ' . $record->lastname),

                        TextEntry::make('email')
                            ->label(new HtmlString('<strong>Email</strong>')),

                        TextEntry::make('phone')
                            ->label(new HtmlString('<strong>Phone</strong>')),

                        TextEntry::make('referrer')
                            ->label(new HtmlString('<strong>Referrer</strong>')),

                        TextEntry::make('created_at')
                            ->label(new HtmlString('<strong>Submitted</strong>'))
                            ->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y')),
                    ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListFormSubmissions::route('/'),
            'create' => Pages\CreateFormSubmission::route('/create'),
            'edit' => Pages\EditFormSubmission::route('/{record}/edit'),
            'view' => Pages\ViewFormSubmission::route('/{record}'),
        ];
    }
}
