<?php

namespace App\Filament\Resources;

use App\Filament\Resources\LetsConnectResource\Pages;
use App\Filament\Resources\LetsConnectResource\RelationManagers;
use App\Models\LetsConnect;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Infolist;
use Filament\Infolists\Components;
use Filament\Infolists\Components\ImageEntry;
use Carbon\Carbon;
use Illuminate\Support\HtmlString;

class LetsConnectResource extends Resource
{
    protected static ?string $model = LetsConnect::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'Forms';

    protected static ?string $navigationLabel = 'User Connect Form';

    protected static ?string $modelLabel = 'Connect Form';

    protected static ?int $navigationSort = 6;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->modifyQueryUsing(
                fn(Builder $query) =>
                $query->orderBy('created_at', 'desc')
            )
            ->columns([
                Tables\Columns\TextColumn::make('form_owner')
                    ->label('Form Owner')
                    ->getStateUsing(function ($record) {
                        if (!$record) return 'N/A';

                        if ($record->subcard) {
                            $sub = $record->subcard;
                            return "{$sub->firstname} {$sub->lastname} - @$sub->username (Sub Card)";
                        }

                        if ($record->user) {
                            $user = $record->user;
                            return "{$user->firstname} {$user->lastname} - @$user->username (Main Card)";
                        }

                        return 'N/A';
                    }),

                Tables\Columns\TextColumn::make('firstname')
                    ->label('Full Name')
                    ->formatStateUsing(function ($state, $record) {
                        return $record->firstname . ' ' . $record->lastname;
                    }),

                Tables\Columns\TextColumn::make('email')
                    ->label('Email'),

                Tables\Columns\TextColumn::make('created_at')
                    ->label('Submitted')
                    ->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y')),
            ])
            ->filters([
                //
            ])
            ->actions([
                // Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                Components\Section::make('Form Details')
                    ->schema([
                        ImageEntry::make('profile_pic')
                            ->label('')
                            ->width(250)
                            ->height(250)
                            ->square()
                            ->defaultImageUrl(asset('/img/profile-placeholder.jpg')),

                        Components\Group::make([
                            TextEntry::make('firstname')
                                ->label(new HtmlString('<strong>Full Name</strong>'))
                                ->formatStateUsing(fn($state, $record) => $record->firstname . ' ' . $record->lastname),

                            TextEntry::make('gender')
                                ->label(new HtmlString('<strong>Gender</strong>')),

                            TextEntry::make('job_title')
                                ->label(new HtmlString('<strong>Job Title</strong>')),

                            TextEntry::make('company')
                                ->label(new HtmlString('<strong>Company</strong>'))
                                ->url(function ($record) {
                                    return $record->company_website;
                                })
                                ->openUrlInNewTab(),

                            TextEntry::make('we_met_at')
                                ->label(new HtmlString('<strong>We met at</strong>')),

                            TextEntry::make('country')
                                ->label(new HtmlString('<strong>Country</strong>')),

                            TextEntry::make('help')
                                ->label(new HtmlString('<strong> How may I help?</strong>')),

                            TextEntry::make('email')
                                ->label(new HtmlString('<strong>Email</strong>')),

                            TextEntry::make('phone')
                                ->label(new HtmlString('<strong>Phone</strong>')),

                            TextEntry::make('created_at')
                                ->label(new HtmlString('<strong>Submitted</strong>'))
                                ->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y')),

                        ]),
                    ])
                    ->columns(2),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListLetsConnects::route('/'),
            'create' => Pages\CreateLetsConnect::route('/create'),
            'edit' => Pages\EditLetsConnect::route('/{record}/edit'),
            'view' => Pages\ViewLetsConnect::route('/{record}'),
        ];
    }
}
