<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PartnershipResource\Pages;
use App\Filament\Resources\PartnershipResource\RelationManagers;
use App\Models\Partnership;
use App\Models\SubCard;
use App\Models\User;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Settings\CardDefaultsSetting;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Infolist;
use Filament\Infolists\Components;
use Filament\Infolists\Components\ImageEntry;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\HtmlString;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;

class PartnershipResource extends Resource
{
    protected static ?string $model = Partnership::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'Forms';

    protected static ?string $navigationLabel = 'Partnership Requests';

    protected static ?string $modelLabel = 'Partnership Request';

    protected static ?int $navigationSort = 5;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->modifyQueryUsing(
                fn(Builder $query) =>
                $query->orderBy('created_at', 'desc')
            )
            ->columns([
                Tables\Columns\TextColumn::make('old_partnership')
                    ->badge()
                    ->label('Current Partnership')
                    ->formatStateUsing(fn($state) => ucfirst($state))
                    ->color(function ($state) {
                        return match ($state) {
                            'junior' => 'danger',
                            'senior' => 'gray',
                            'default' => 'info',
                            'leader' => 'success',
                            default => 'warning',
                        };
                    }),

                Tables\Columns\TextColumn::make('requested_partnership')
                    ->badge()
                    ->label('Requested Partnership')
                    ->formatStateUsing(fn($state) => ucfirst($state))
                    ->color(function ($state) {
                        return match ($state) {
                            'junior' => 'danger',
                            'senior' => 'gray',
                            'default' => 'info',
                            'leader' => 'success',
                            default => 'warning',
                        };
                    }),

                Tables\Columns\TextColumn::make('user.firstname')
                    ->label('Client')
                    ->formatStateUsing(
                        fn($state, $record) =>
                        $record->user
                            ? "{$record->user->firstname} {$record->user->lastname}"
                            : 'N/A'
                    ),

                Tables\Columns\TextColumn::make('created_at')
                    ->label('Date')
                    ->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y')),
            ])
            ->filters([
                //
            ])
            ->actions([
                // Tables\Actions\EditAction::make(),
            ]);
        // ->bulkActions([
        //     Tables\Actions\BulkActionGroup::make([
        //         Tables\Actions\DeleteBulkAction::make(),
        //     ]),
        // ]);
    }

    public static function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                Components\Section::make('Form Details')
                    ->schema([
                        ImageEntry::make('receipt')
                            ->label(new HtmlString('<strong>Receipt</strong>'))
                            ->square()
                            ->width('80%')
                            ->height('80%')
                            ->extraImgAttributes([
                                'alt' => 'Receipt',
                                'loading' => 'lazy',
                            ])
                            ->defaultImageUrl(asset('/img/product-placeholder.jpg')),

                        Components\Group::make([
                            TextEntry::make('user.firstname')
                                ->label(new HtmlString('<strong>Client</strong>'))
                                ->formatStateUsing(
                                    fn($state, $record) =>
                                    $record->user
                                        ? "{$record->user->firstname} {$record->user->lastname}"
                                        : 'N/A'
                                ),

                            TextEntry::make('user.email')
                                ->label(new HtmlString('<strong>Email</strong>'))
                                ->formatStateUsing(
                                    fn($state, $record) =>
                                    $record->user
                                        ? "{$record->user->email}"
                                        : 'N/A'
                                ),

                            TextEntry::make('created_at')
                                ->label(new HtmlString('<strong>Requested</strong>'))
                                ->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y')),

                            TextEntry::make('old_partnership')
                                ->label(new HtmlString('<strong>Partnership level before requesting</strong>'))
                                ->badge()
                                ->formatStateUsing(fn($state) => ucfirst($state))
                                ->color(function ($state) {
                                    return match ($state) {
                                        'junior' => 'danger',
                                        'senior' => 'gray',
                                        'default' => 'info',
                                        'leader' => 'success',
                                        default => 'warning',
                                    };
                                }),

                            TextEntry::make('requested_partnership')
                                ->label(new HtmlString('<strong>Upgrade partnership level to</strong>'))
                                ->badge()
                                ->formatStateUsing(fn($state) => ucfirst($state))
                                ->color(function ($state) {
                                    return match ($state) {
                                        'junior' => 'danger',
                                        'senior' => 'gray',
                                        'default' => 'info',
                                        'leader' => 'success',
                                        default => 'warning',
                                    };
                                }),
                        ]),
                    ])
                    ->columns(2),

            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPartnerships::route('/'),
            'create' => Pages\CreatePartnership::route('/create'),
            'edit' => Pages\EditPartnership::route('/{record}/edit'),
            'view' => Pages\ViewPartnership::route('/{record}'),
        ];
    }
}
