<?php

namespace App\Filament\Resources\SponsorResource\Widgets;

use Carbon\Carbon;
use App\Models\Analytics;
use App\Models\Ad;
use Filament\Widgets\ChartWidget;
use Flowframe\Trend\Trend;
use Flowframe\Trend\TrendValue;
use Illuminate\Database\Eloquent\Model;

class SponsorAdAnalyticsOneWeek extends ChartWidget
{
    protected static ?string $heading = 'Ad clicks (Last 7 Days)';
    protected static string $color = 'success';
    public ?Model $record = null;

    protected function getData(): array
    {
        $adIds = Ad::where('is_active', true)
            ->where('display_in', 'Sponsored')
            ->where('sponsor_id', $this->record->id)
            ->pluck('id');

        $startDate = now()->subDays(6);
        $endDate = now();

        $datasets = [];
        $labels = collect();

        // Define a list of distinct colors
        $colors = [
            '#4caf50',
            '#2196f3',
            '#ff9800',
            '#9c27b0',
            '#f44336',
            '#00bcd4',
            '#3f51b5',
            '#795548',
            '#607d8b',
            '#e91e63'
        ];

        $colorIndex = 0;

        foreach ($adIds as $adId) {
            $trend = Trend::query(
                Analytics::where('type', 'ad_click')
                    ->where('ad_id', $adId)
            )
                ->dateColumn('clicked_at')
                ->between($startDate, $endDate)
                ->perDay()
                ->count();

            if ($labels->isEmpty()) {
                $labels = $trend->map(fn(TrendValue $value) => Carbon::parse($value->date)->format('M Y'));
            }

            $ad = Ad::find($adId);
            $datasets[] = [
                'label' => $ad?->title ?? 'Ad #' . $adId,
                'data' => $trend->map(fn(TrendValue $value) => $value->aggregate),
                'backgroundColor' => $colors[$colorIndex % count($colors)],
                'borderColor' => $colors[$colorIndex % count($colors)],
                'fill' => false, // for line chart – optional
                'tension' => 0.3, // optional for smooth curves
            ];

            $colorIndex++;
        }

        return [
            'datasets' => $datasets,
            'labels' => $labels,
        ];
    }

    protected function getType(): string
    {
        return 'line';
    }
}
