<?php

namespace App\Filament\Resources\SubCardsResource\Pages;

use App\Filament\Resources\SubCardsResource;
use Filament\Resources\Pages\CreateRecord;
use App\Models\SubCard;
use App\Models\ColorPreset;

class CreateSubCards extends CreateRecord
{
    protected static string $resource = SubCardsResource::class;

    // Capture full form data including non-model fields
    protected array $rawFormData = [];

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $this->rawFormData = $data;
        return $data; // must return for actual SubCard creation
    }

    protected function afterCreate(): void
    {
        /** @var SubCard $subcard */
        $subcard = $this->record;

        $formState = $this->rawFormData;

        // --- Apply preset if selected ---
        if (!empty($formState['preset']) && $formState['preset'] !== 'Custom') {
            $preset = ColorPreset::find($formState['preset']);

            if ($preset) {
                $formState['color_settings_custom_button']      = $preset->custom_button;
                $formState['color_settings_custom_button_text'] = $preset->custom_button_text;
                $formState['color_settings_link']               = $preset->link;
                $formState['color_settings_profile_pic_border'] = $preset->profile_pic_border;
                $formState['color_settings_card_light']         = $preset->card_light;
                $formState['color_settings_card_dark']          = $preset->card_dark;
                $formState['color_settings_text_light']         = $preset->text_light;
                $formState['color_settings_text_dark']          = $preset->text_dark;
            }
        }

        // --- Default fallback values ---
        $defaults = [
            'button_style'                          => 'rounded',
            'color_settings_custom_button'          => '#facc15',
            'color_settings_custom_button_text'     => '#000000',
            'color_settings_link'                   => '#ca8a04',
            'color_settings_profile_pic_border'     => '#ca8a04',
            'color_settings_card_light'             => '#ffffff',
            'color_settings_card_dark'              => '#18181b',
            'color_settings_text_light'             => '#1e293b',
            'color_settings_text_dark'              => '#cbd5e1',

            'profile_layout'                        => null,
            'card_custom_title'                     => null,
            'footer_text'                           => null,
            'footer_link'                           => null,

            'searchable'                            => true,
            'display_username'                      => true,
            'display_short_bio'                     => true,
            'display_country'                       => true,
            'connect_main'                          => true,
            'connect_bio'                           => false,
            'gallery_main'                          => true,
            'gallery_bio'                           => false,
            'product_price_enabled'                 => true,
            'services_price_enabled'                => true,
            'footer_enabled'                        => true,
            'getacard_enabled'                      => false,
            'shop_text'                             => 'Shop',
            'shop_more'                             => null,
            'shop_thumbnail'                        => null,
            'services_text'                         => 'Services',
            'contact_text'                          => 'Contact me',
            'gallery_two_slide'                     => true,
            'event_text'                            => 'Events & Promotions',
            'follow_text'                           => 'Follow me',
            'payment_text'                          => 'Payment Links',
        ];

        // --- Save settings ---
        foreach ($defaults as $key => $default) {
            $value = $formState[$key] ?? $default;

            $subcard->settings()->updateOrCreate(
                ['setting_key' => $key, 'user_id' => null],
                ['setting_value' => $value]
            );
        }

        // Save preset ID itself
        if (!empty($formState['preset'])) {
            $subcard->settings()->updateOrCreate(
                ['setting_key' => 'preset', 'user_id' => null],
                ['setting_value' => $formState['preset']]
            );
        }
    }

    protected function getRedirectUrl(): string
    {
        return static::$resource::getUrl('edit', ['record' => $this->record->getKey()]);
    }
}
