<?php

namespace App\Filament\Resources;

use App\Filament\Resources\SubscriptionRewardsResource\Pages;
use App\Filament\Resources\SubscriptionRewardsResource\RelationManagers;
use App\Models\SubscriptionRewards;
use App\Models\User;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Infolist;
use Filament\Infolists\Components;
use Filament\Infolists\Components\ImageEntry;
use Carbon\Carbon;
use Illuminate\Support\HtmlString;
use Filament\Support\Enums\IconPosition;
use App\Settings\CardDefaultsSetting;

class SubscriptionRewardsResource extends Resource
{
    protected static ?string $model = SubscriptionRewards::class;

    protected static ?string $navigationIcon = 'heroicon-o-circle-stack';

    protected static ?string $navigationGroup = 'Client Management';
    protected static ?string $navigationLabel = 'Rewards';
    protected static ?int $navigationSort = 6;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->modifyQueryUsing(
                fn(Builder $query) =>
                $query->orderBy('created_at', 'desc')
            )
            ->columns([
                Tables\Columns\TextColumn::make('product_id')
                    ->label('Subscription')
                    ->formatStateUsing(fn($state, $record) => $record->product?->product_name ?? 'N/A'),

                Tables\Columns\TextColumn::make('coin')
                    ->label('Reward')->badge(),

                Tables\Columns\TextColumn::make('price')
                    ->label('Price'),

                Tables\Columns\TextColumn::make('firstname')
                    ->label('Full Name')
                    ->formatStateUsing(function ($state, $record) {
                        return $record->firstname . ' ' . $record->lastname;
                    }),

                Tables\Columns\TextColumn::make('created_at')
                    ->label('Subscribed')->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y')),
            ])
            ->filters([
                //
            ])
            ->actions([
                // Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                Components\Section::make('Subscription Details')
                    ->schema([
                        Components\Group::make([

                            Components\Group::make([
                                ImageEntry::make('receipt')
                                    ->label('')
                                    ->width('100%')
                                    ->height('100%')
                                    ->defaultImageUrl(asset('/img/profile-placeholder.jpg'))
                                    ->square(),
                            ]),

                            Components\Group::make([

                                TextEntry::make('product_id')
                                    ->label(function () {
                                        return new HtmlString(
                                            '<strong>Subscription Item</strong>'
                                        );
                                    })->formatStateUsing(fn($state, $record) => $record->product?->product_name ?? 'N/A')
                                    ->badge()
                                    ->icon('heroicon-m-arrow-top-right-on-square')
                                    ->iconPosition(IconPosition::After)
                                    ->url(function ($record) {
                                        // Get username from user_id
                                        $username = User::find($record->user_id)?->username ?? 'unknown';

                                        return app(CardDefaultsSetting::class)->site_url
                                            . $username
                                            . '/subscription/' . $record->product_id;
                                    })
                                    ->openUrlInNewTab(),

                                TextEntry::make('price')->label(function () {
                                    return new HtmlString(
                                        '<strong>Price</strong>'
                                    );
                                })->badge(),

                                TextEntry::make('coin')->label(function () {
                                    return new HtmlString(
                                        '<strong>Reward</strong>'
                                    );
                                })->badge(),

                                TextEntry::make('created_at')->label(function () {
                                    return new HtmlString(
                                        '<strong>Subscribe</strong>'
                                    );
                                })->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y')),
                            ]),

                            Components\Group::make([
                                TextEntry::make('firstname')
                                    ->label(function () {
                                        return new HtmlString(
                                            '<strong>Full Name</strong>'
                                        );
                                    })
                                    ->formatStateUsing(fn($state, $record) => $record->firstname . ' ' . $record->lastname),

                                TextEntry::make('email')->label(function () {
                                    return new HtmlString(
                                        '<strong>Email</strong>'
                                    );
                                }),
                                TextEntry::make('phone')->label(function () {
                                    return new HtmlString(
                                        '<strong>Phone</strong>'
                                    );
                                }),
                                TextEntry::make('special_note')->label(function () {
                                    return new HtmlString(
                                        '<strong>Special Note</strong>'
                                    );
                                }),
                            ]),

                        ])->columns(3),
                    ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSubscriptionRewards::route('/'),
            'create' => Pages\CreateSubscriptionRewards::route('/create'),
            'edit' => Pages\EditSubscriptionRewards::route('/{record}/edit'),
            'view' => Pages\ViewSubscriptionRewards::route('/{record}'),
        ];
    }
}
