<?php

namespace App\Filament\Resources\TeamResource\Pages;

use App\Filament\Resources\TeamResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditTeam extends EditRecord
{
    protected static string $resource = TeamResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('view_card')
                ->label('View')
                ->icon('heroicon-o-eye')
                // ->url(fn($record) => app(CardDefaultsSetting::class)->site_url . $record->user->username . '/sales/' . $record->id)
                ->url(function ($record) {
                    $baseUrl = app(\App\Settings\CardDefaultsSetting::class)->site_url;

                    if ($record->page_id && $record->subcard) {
                        // Sale belongs to a subcard → use parent user’s username
                        return $baseUrl . $record->subcard->username . '/team/' . $record->id;
                    }

                    if ($record->user) {
                        // Sale belongs directly to a user
                        return $baseUrl . $record->user->username . '/team/' . $record->id;
                    }

                    return '#'; // fallback
                })
                ->openUrlInNewTab()
                ->color('info'),

            Actions\DeleteAction::make()
                ->modalHeading('Are you sure you want to delete this team?')
                ->modalDescription('This action cannot be undone.'),
        ];
    }

    public function getTitle(): string
    {
        return "Edit Team";
    }
}
