<?php

namespace App\Filament\Resources;

use App\Models\User;

use Closure;
use Filament\Forms\Get;
use App\Models\Button;
use App\Models\SubCard;
use App\Filament\Resources\UserResource\Pages;
use App\Filament\Resources\UserResource\RelationManagers;
use App\Filament\Resources\UserResource\RelationManagers\AdRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\ButtonsRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\ContactsRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\PaymentRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\ProductsRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\ServicesRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\SocialsRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\VideosRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\ImagesRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\SubcardsRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\EventsRelationManager;
// use App\Filament\Resources\UserResource\RelationManagers\SalesRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\TrustedNetworkRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\DirectionsRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\CommunitiesRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\TeamsRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\CategoryRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\ProductCollectionRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\ReplaysRelationManager;
use App\Filament\Resources\UserResource\RelationManagers\ReviewsRelationManager;
use Filament\Tables\Filters\Filter;
use Filament\Tables\Filters\SelectFilter;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Facades\Hash;
use App\Settings\CardDefaultsSetting;
use Filament\Forms\Components\FileUpload;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Filament\Forms\Components\TextInput;
use Carbon\Carbon;
use AmidEsfahani\FilamentTinyEditor\TinyEditor;
use App\Filament\Resources\UserResource\RelationManagers\PagesRelationManager;
use App\Models\ColorPreset;
use Laravel\Cashier\Subscription;
use Illuminate\Support\Facades\Log;
use Filament\Forms\Components\Tabs;
use Filament\Forms\Components\ColorPicker;
use Filament\Forms\Components\MarkdownEditor;
use Filament\Forms\Components\RichEditor;
use Filament\Tables\Actions\Action;
use Illuminate\Database\Eloquent\Model;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Collection;
use Filament\Tables\Actions\BulkAction;
use App\Models\Social;
use Filament\Forms\Components\ViewField;
use Malzariey\FilamentLexicalEditor\Enums\ToolbarItem;
use Malzariey\FilamentLexicalEditor\FilamentLexicalEditor;
use Illuminate\Support\Facades\Http;
use Kahusoftware\FilamentCkeditorField\CKEditor;

class UserResource extends Resource
{
    protected static ?string $model = User::class;

    protected static ?string $navigationIcon = 'heroicon-o-users';

    protected static ?string $navigationLabel = 'Clients';

    protected static ?string $modelLabel = 'Client';

    protected static ?string $navigationGroup = 'Client Management';

    protected static ?string $slug = 'clients';

    protected static ?int $navigationSort = 1;

    public $site_url;

    public $bio_long_prev_length = 0;

    public $availableStates = [];

    public function fetchStates($country)
    {
        if (!$country) {
            $this->availableStates = [];
            return;
        }

        $response = Http::post('https://countriesnow.space/api/v0.1/countries/states', [
            'country' => $country,
        ]);

        if ($response->ok()) {
            $states = data_get($response->json(), 'data.states', []);

            // Convert API response to key => value for Filament select
            $this->availableStates = collect($states)
                ->mapWithKeys(fn($state) => [$state['state_code'] => $state['name']])
                ->toArray();
        } else {
            $this->availableStates = [];
        }
    }

    protected static function getTableBulkActions(): array
    {
        return [
            Tables\Actions\DeleteBulkAction::make(),
            // Bulk Edit
            Tables\Actions\BulkAction::make('bulkEdit')
                ->label('Bulk Edit')
                ->icon('heroicon-o-pencil-square')
                ->form(function (Collection $records) {
                    return [
                        Forms\Components\CheckboxList::make('fields')
                            ->label('Select fields to edit')
                            ->options([
                                'user_type' => 'User Type',
                                // 'partnership_level' => 'Partnership Level',
                                'job_title' => 'Job Title',
                                'company' => 'Company',
                                'company_website' => 'Company Website',
                                // 'country' => 'Country',
                                'is_active' => 'Account Active'

                            ])
                            ->reactive(), // makes it re-render when updated

                        Forms\Components\Select::make('user_type')
                            ->label('User Type')

                            ->options(function () {
                                $settings = app(CardDefaultsSetting::class);

                                return [
                                    'Free' => 'Free',
                                    'Basic' => $settings->term_basic,
                                    'Gold' => $settings->term_gold,
                                    'Platinum' => $settings->term_platinum,
                                    'Sponsored' => 'Sponsored',
                                    'Influencer' => 'Influencer',
                                ];
                            })
                            ->hidden(fn(callable $get) => ! in_array('user_type', $get('fields') ?? [])),

                        Forms\Components\TextInput::make('job_title')
                            ->required()
                            ->maxLength(200)
                            ->default(null)
                            ->hidden(fn(callable $get) => ! in_array('job_title', $get('fields') ?? [])),

                        Forms\Components\TextInput::make('company')
                            ->maxLength(255)
                            ->default(null)
                            ->hidden(fn(callable $get) => ! in_array('company', $get('fields') ?? [])),

                        Forms\Components\TextInput::make('company_website')
                            ->maxLength(255)
                            ->url()
                            ->columnSpanFull()
                            ->default(null)
                            ->hidden(fn(callable $get) => ! in_array('company_website', $get('fields') ?? [])),

                        Forms\Components\Toggle::make('is_active')
                            ->label('Account Active')
                            ->default(true)
                            ->hidden(fn(callable $get) => ! in_array('is_active', $get('fields') ?? [])),

                        // Forms\Components\Select::make('partnership_level')
                        //     ->label('Partnership Level')
                        //     ->searchable()
                        //     ->preload()
                        //     ->reactive()
                        //     ->default(NULL)
                        //     ->options([
                        //         'default' => 'Default - 10%',
                        //         'leader' => 'Leader - 20%',
                        //         'junior' => 'Junior - 25%',
                        //         'senior' => 'Senior - 50%',
                        //     ])
                        //     ->disabled(fn(callable $get) => !in_array($get('user_type'), ['Gold', 'Platinum']))
                        //     ->hidden(fn(callable $get) => ! in_array('partnership_level', $get('fields') ?? [])),
                    ];
                })
                ->modalButton('Save Changes')
                ->action(function (Collection $records, array $data): void {
                    $fields = $data['fields'] ?? [];

                    foreach ($records as $record) {
                        foreach ($fields as $field) {
                            if (!empty($data[$field])) {
                                $record->$field = $data[$field];
                            }
                        }
                        $record->save();
                        Notification::make()
                            ->title('Success')
                            ->body('Card successfully updated.')
                            ->success()
                            ->send();
                    }
                }),

            //Add Button(s)
            Tables\Actions\BulkAction::make('addButtons')
                ->label('Add Button(s)')
                ->icon('heroicon-o-plus-circle')
                ->form([
                    Forms\Components\Repeater::make('buttons')
                        ->label('Buttons')
                        ->minItems(1)
                        ->defaultItems(1)
                        ->collapsible()
                        ->grid(2)
                        ->schema([
                            Forms\Components\Select::make('type')
                                ->required()
                                ->label('Link Type')
                                ->options([
                                    'link'      => 'Link',
                                    'community' => 'Community',
                                    'email'     => 'Email',
                                    'phone'     => 'Phone',
                                    'sms'       => 'SMS',
                                    'whatsapp'  => 'WhatsApp',
                                    'telegram'  => 'Telegram',
                                ])
                                ->default('link')
                                ->columnSpan(1),

                            Forms\Components\TextInput::make('title')
                                ->required()
                                ->maxLength(255)
                                ->default('New Button')
                                ->columnSpan(1),

                            Forms\Components\TextInput::make('link')
                                ->columnSpanFull()
                                ->default('https://')
                                ->required(),

                            Forms\Components\Toggle::make('is_active')
                                ->columnSpanFull()
                                ->label('Active')
                                ->default(true)
                                ->required(),
                        ]),
                ])
                ->modalButton('Add Buttons')
                ->action(function (Collection $records, array $data): void {
                    foreach ($records as $user) {
                        // 🔒 Free plan limit: max 4 buttons
                        if ($user->user_type === 'Free' && $user->buttons()->count() >= 4) {
                            Notification::make()
                                ->warning()
                                ->title("Free card holders can only add up to 4 button links!")
                                ->persistent()
                                ->send();
                            continue; // skip this user
                        }

                        foreach ($data['buttons'] as $button) {
                            try {
                                // 🔎 Validate & format link (your custom logic)
                                Button::handleLinkFormatting($button);

                                $user->buttons()->create([
                                    'type'       => $button['type'],
                                    'title'      => $button['title'],
                                    'link'       => $button['link'] ?? null,
                                    'is_active'  => $button['is_active'] ?? true,
                                    'display_as' => 'button',
                                ]);

                                Notification::make()
                                    ->title('Buttons Added')
                                    ->body('New button(s) have been added to selected users (if valid).')
                                    ->success()
                                    ->send();
                            } catch (\InvalidArgumentException $e) {
                                Notification::make()
                                    ->title('Validation Error')
                                    ->body($e->getMessage())
                                    ->danger()
                                    ->send();
                            }
                        }
                    }
                }),

            // Add Contact(s)
            Tables\Actions\BulkAction::make('addContacts')
                ->label('Add Contact(s)')
                ->icon('heroicon-o-plus-circle')
                ->form([
                    Forms\Components\Repeater::make('contacts')
                        ->label('Contacts')
                        ->schema([
                            Forms\Components\Select::make('type')
                                ->required()
                                ->label('Contact Type')
                                ->reactive()
                                ->afterStateUpdated(function ($state, callable $set) {
                                    $titles = [
                                        'email'     => 'Email',
                                        'phone'     => 'Phone',
                                        'sms'       => 'SMS/Text',
                                        'whatsapp'  => 'WhatsApp',
                                        'telegram'  => 'Telegram',
                                        'zoom'      => 'Zoom',
                                        'community' => 'Community',
                                    ];
                                    $set('title', $titles[$state] ?? '');
                                })
                                ->options([
                                    'email'     => 'Email',
                                    'phone'     => 'Phone',
                                    'sms'       => 'SMS/Text',
                                    'whatsapp'  => 'WhatsApp',
                                    'telegram'  => 'Telegram',
                                    'zoom'      => 'Zoom',
                                    'community' => 'Community',
                                ]),

                            Forms\Components\TextInput::make('title')
                                ->required()
                                ->maxLength(255),

                            Forms\Components\TextInput::make('link')
                                ->columnSpanFull()
                                ->required()
                                ->maxLength(255),

                            Forms\Components\Toggle::make('is_active')
                                ->columnSpanFull()
                                ->label('Active')
                                ->default(true)
                                ->required(),
                        ])
                        ->minItems(1)
                        ->maxItems(10)
                        ->createItemButtonLabel('Add Another Contact'),
                ])
                ->modalButton('Add Contact(s)')
                ->action(function (Collection $records, array $data): void {
                    foreach ($records as $user) {
                        foreach ($data['contacts'] as $contact) {
                            try {
                                // Run your validation / formatting
                                \App\Models\Button::handleLinkFormatting($contact);

                                // Enforce Free-plan contact limit
                                if ($user->user_type === 'Free' && $user->buttons()->where('view', 'contacts')->count() >= 4) {
                                    Notification::make()
                                        ->warning()
                                        ->title('Free card holders can only add up to 4 contact points!')
                                        ->persistent()
                                        ->send();
                                    continue; // skip this user
                                }

                                $user->buttons()->create([
                                    'type'      => $contact['type'],
                                    'title'     => $contact['title'],
                                    'link'      => $contact['link'] ?? null,
                                    'is_active' => $contact['is_active'] ?? true,
                                    'view'      => 'contacts',
                                ]);

                                Notification::make()
                                    ->title('Contacts Added')
                                    ->body('The new contact(s) have been added to all selected users.')
                                    ->success()
                                    ->send();
                            } catch (\Throwable $e) {
                                // Gracefully handle errors without breaking other inserts
                                Notification::make()
                                    ->title('Error Adding Contact')
                                    ->body("User {$user->id}: {$e->getMessage()}")
                                    ->danger()
                                    ->send();
                            }
                        }
                    }
                }),

            //Add Payment(s)
            Tables\Actions\BulkAction::make('addPayments')
                ->label('Add Payment(s)')
                ->icon('heroicon-o-banknotes')
                ->form([
                    Forms\Components\Repeater::make('payments')
                        ->label('Payments')
                        ->schema([
                            Forms\Components\Select::make('type')
                                ->required()
                                ->label('Payment Type')
                                ->reactive()
                                ->afterStateUpdated(function ($state, callable $set) {
                                    $urls = [
                                        'cashapp' => 'https://cash.app/$',
                                        'venmo' => 'https://venmo.com/u/',
                                        'paypal_link' => 'https://www.paypal.me/',
                                        'instagram' => 'https://www.instagram.com/',
                                    ];

                                    $titles = [
                                        'cashapp' => 'Cashapp',
                                        'paypal_link' => 'Paypal Link',
                                        'paypal_email' => 'Paypal Email',
                                        'apple_pay' => 'Apple Pay',
                                        'venmo' => 'Venmo',
                                        'credit' => 'Credit Card',
                                        'zelle' => 'Zelle',
                                    ];

                                    $set('link', $urls[$state] ?? '');
                                    $set('title', $titles[$state] ?? '');
                                })
                                ->options([
                                    'cashapp' => 'Cashapp',
                                    'paypal_link' => 'Paypal Link',
                                    'paypal_email' => 'Paypal Email',
                                    'apple_pay' => 'Apple Pay',
                                    'venmo' => 'Venmo',
                                    'credit' => 'Credit Card',
                                    'zelle' => 'Zelle',
                                ]),

                            Forms\Components\TextInput::make('title')
                                ->required()
                                ->maxLength(255),

                            Forms\Components\TextInput::make('link')
                                ->columnSpanFull()
                                ->required()
                                ->maxLength(255),

                            Forms\Components\Toggle::make('is_active')
                                ->label('Active')
                                ->default(true)
                                ->columnSpanFull(),
                        ])
                        ->minItems(1)
                        ->maxItems(10)
                        ->createItemButtonLabel('Add Another Payment'),
                ])
                ->modalButton('Add Payment(s)')
                ->action(function (\Illuminate\Support\Collection $records, array $data): void {
                    foreach ($records as $user) {
                        foreach ($data['payments'] as $payment) {
                            try {
                                // Validate / format
                                Button::handleLinkFormatting($payment);

                                // Free plan restriction
                                if ($user->user_type === 'Free' && $user->buttons()->where('view', 'payments')->count() >= 4) {
                                    Notification::make()
                                        ->warning()
                                        ->title('Free card holders can only add up to 4 payment links!')
                                        ->persistent()
                                        ->send();
                                    continue; // skip this user
                                }

                                $user->buttons()->create([
                                    'type'      => $payment['type'],
                                    'title'     => $payment['title'],
                                    'link'      => $payment['link'],
                                    'is_active' => $payment['is_active'] ?? true,
                                    'view'      => 'payments',
                                ]);

                                Notification::make()
                                    ->title('Payments Added')
                                    ->body('The new payment option(s) have been added.')
                                    ->success()
                                    ->send();
                            } catch (\InvalidArgumentException $e) {
                                // Catch validation or formatting errors
                                Notification::make()
                                    ->title('Validation Error')
                                    ->body($e->getMessage())
                                    ->danger()
                                    ->send();

                                continue; // Skip this payment and move to the next
                            }
                        }
                    }
                }),

            // Add Social(s)
            Tables\Actions\BulkAction::make('addSocials')
                ->label('Add Social(s)')
                ->icon('heroicon-o-globe-alt')
                ->form([
                    Forms\Components\Repeater::make('socials')
                        ->label('Social Links')
                        ->schema([
                            Forms\Components\Select::make('type')
                                ->required()
                                ->label('Social Media')
                                ->reactive()
                                ->afterStateUpdated(function ($state, callable $set) {
                                    $urls = [
                                        'facebook' => 'https://www.facebook.com/',
                                        'x' => 'https://x.com/',
                                        'linkedin' => 'https://www.linkedin.com/in/',
                                        'instagram' => 'https://www.instagram.com/',
                                        'tiktok' => 'https://www.tiktok.com/@',
                                        'youtube' => 'https://www.youtube.com/@',
                                        'clubhouse' => 'https://www.clubhouse.com/',
                                        'threads' => 'https://www.threads.net/@',
                                        'fanbase' => 'https://www.fanbase.app/@',
                                        'snapchat' => 'https://www.snapchat.com/add/',
                                        'pinterest' => 'https://www.pinterest.com/username',
                                        'soundcloud' => 'https://soundcloud.com/username',
                                        'apple_podcasts' => 'https://podcasts.apple.com/podcast/id',
                                        'spotify' => 'https://open.spotify.com/user/username',
                                        'discord' => 'https://discord.gg/invitecode',
                                    ];

                                    $set('link', $urls[$state] ?? '');
                                })
                                ->options([
                                    'facebook' => 'Facebook',
                                    'x' => 'X',
                                    'linkedin' => 'Linkedin',
                                    'instagram' => 'Instagram',
                                    'tiktok' => 'Tiktok',
                                    'youtube' => 'Youtube',
                                    'clubhouse' => 'Clubhouse',
                                    'threads' => 'Threads',
                                    'fanbase' => 'Fanbase',
                                    'snapchat' => 'Snapchat',
                                    'pinterest' => 'Pinterest',
                                    'soundcloud' => 'SoundCloud',
                                    'apple_podcasts' => 'Apple Podcasts',
                                    'spotify' => 'Spotify',
                                    'discord' => 'Discord',
                                ]),
                            Forms\Components\TextInput::make('link')
                                ->required()
                                ->maxLength(255),
                            Forms\Components\Toggle::make('is_active')
                                ->label('Active')
                                ->default(true)
                                ->columnSpanFull(),
                        ])
                        ->minItems(1)
                        ->createItemButtonLabel('Add Another Social Link'),
                ])
                ->modalButton('Add Social(s)')
                ->action(function (\Illuminate\Support\Collection $records, array $data) {
                    foreach ($records as $user) {
                        foreach ($data['socials'] as $social) {
                            try {
                                Social::handleLinkFormatting($social);

                                // Free plan restriction
                                if ($user->user_type === 'Free' && $user->socials()->count() >= 3) {
                                    Notification::make()
                                        ->warning()
                                        ->title('Free card holders can only add up to 3 social links!')
                                        ->persistent()
                                        ->send();
                                    continue;
                                }

                                // Create the social link
                                $user->socials()->create([
                                    'type'      => $social['type'],
                                    'link'      => $social['link'],
                                    'is_active' => $social['is_active'] ?? true,
                                    'user_id'   => $user->id,
                                ]);
                            } catch (\InvalidArgumentException $e) {
                                Notification::make()
                                    ->title('Validation Error')
                                    ->body($e->getMessage())
                                    ->danger()
                                    ->send();

                                continue;
                            }
                        }
                    }

                    Notification::make()
                        ->title('Socials Added')
                        ->body('The new social media link(s) have been added successfully.')
                        ->success()
                        ->send();
                }),


        ];
    }

    public static function bulkEditModalForm($fields, Collection $records)
    {
        if (is_null($fields)) {
            return Forms\Components\Placeholder::make('error')
                ->content('No fields selected');
        }

        $formFields = self::getBulkEditFormFields($fields);
        return Forms\Components\Section::make('Edit Fields')
            ->schema($formFields);
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Tabs::make('Tab')
                    ->tabs([
                        Tabs\Tab::make('Account')
                            ->schema([
                                Forms\Components\Section::make('Account Details')
                                    ->description('Manage account details here')
                                    ->schema([
                                        Forms\Components\Select::make('referrer_id_main')
                                            ->disabled(fn($context, $record) => $context === 'edit' && $record?->referral)
                                            ->label('Referrer')
                                            ->placeholder('Search Client')
                                            ->helperText('Leave empty if no referrer.')
                                            ->searchable()
                                            ->visible(app(CardDefaultsSetting::class)->affiliate_functionality)
                                            ->getSearchResultsUsing(function (string $search): array {
                                                // Search Users
                                                $users = User::query()
                                                    ->when(
                                                        strpos($search, '@') === 0 && strlen($search) > 1,
                                                        fn($query) => $query->where('username', 'like', '%' . substr($search, 1) . '%'),
                                                        fn($query) => $query->where(function ($q) use ($search) {
                                                            $q->where('firstname', 'like', "%{$search}%")
                                                                ->orWhere('lastname', 'like', "%{$search}%")
                                                                ->orWhere('username', 'like', "%{$search}%");
                                                        })
                                                    )
                                                    ->whereIn('user_type', ['Platinum', 'Gold'])
                                                    ->limit(25)
                                                    ->get()
                                                    ->mapWithKeys(fn($user) => [
                                                        'user_' . $user->id => "{$user->firstname} {$user->lastname} - @{$user->username} (Main)",
                                                    ]);

                                                // Search SubCards (same fields as User)
                                                $subcards = SubCard::query()
                                                    ->when(
                                                        strpos($search, '@') === 0 && strlen($search) > 1,
                                                        fn($query) => $query->where('username', 'like', '%' . substr($search, 1) . '%'),
                                                        fn($query) => $query->where(function ($q) use ($search) {
                                                            $q->where('firstname', 'like', "%{$search}%")
                                                                ->orWhere('lastname', 'like', "%{$search}%")
                                                                ->orWhere('username', 'like', "%{$search}%");
                                                        })
                                                    )
                                                    ->limit(25)
                                                    ->get()
                                                    ->mapWithKeys(fn($sub) => [
                                                        'sub_' . $sub->id => "{$sub->firstname} {$sub->lastname} - @{$sub->username} (SubCard)",
                                                    ]);

                                                return $users->union($subcards)->toArray();
                                            })
                                            ->getOptionLabelUsing(function ($value) {
                                                if (str_starts_with($value, 'user_')) {
                                                    $id = (int) str_replace('user_', '', $value);
                                                    if ($user = User::find($id)) {
                                                        return "{$user->firstname} {$user->lastname} - @{$user->username} (Main Card)";
                                                    }
                                                }

                                                if (str_starts_with($value, 'sub_')) {
                                                    $id = (int) str_replace('sub_', '', $value);
                                                    if ($sub = SubCard::find($id)) {
                                                        return "{$sub->firstname} {$sub->lastname} - @{$sub->username} (Sub Card)";
                                                    }
                                                }

                                                return $value;
                                            })

                                            ->columnSpanFull(),


                                        Forms\Components\Select::make('user_type')
                                            ->helperText('If you leave the "card type" empty, the client will be redirected to payment page on their first login.')
                                            ->label('Card Type')
                                            ->options(function () {
                                                $settings = app(CardDefaultsSetting::class);

                                                $options = [
                                                    'Free' => 'Free',
                                                    'Basic' => $settings->term_basic,
                                                    'Gold' => $settings->term_gold,
                                                    'Platinum' => $settings->term_platinum,
                                                    'Sponsored' => 'Sponsored',
                                                    'Influencer' => 'Influencer',
                                                ];

                                                if (! $settings->platinum_enabled) {
                                                    unset($options['Platinum']);
                                                }

                                                if (! $settings->influencer_enabled) {
                                                    unset($options['Influencer']);
                                                }

                                                if (! $settings->sponsored_enabled) {
                                                    unset($options['Sponsored']);
                                                }

                                                return $options;
                                            })
                                            ->reactive(),

                                        Forms\Components\TextInput::make('username')
                                            ->reactive()
                                            ->live(onBlur: true)
                                            ->afterStateUpdated(function (callable $set, $state) {
                                                $set('footer_link', app(CardDefaultsSetting::class)->site_url . 'register?ref=' . $state);
                                            })
                                            ->required()
                                            ->label('Username')
                                            ->maxLength(50)
                                            ->rule('regex:/^[a-zA-Z0-9_.]+$/')
                                            ->rule(function ($get, $livewire) {
                                                return function (string $attribute, $value, $fail) use ($livewire) {
                                                    $record = $livewire->record ?? null;

                                                    // Only validate if creating or the username has changed
                                                    if (!$record || $record->username !== $value) {
                                                        $userExists = DB::table('users')->where('username', $value)->exists();
                                                        $subcardExists = DB::table('subcards')->where('username', $value)->exists();

                                                        if ($userExists || $subcardExists) {
                                                            $fail("The username '$value' is already taken.");
                                                        }
                                                    }
                                                };
                                            })

                                            ->helperText('Only letters, numbers, and underscores allowed.'),

                                        Forms\Components\TextInput::make('email')
                                            ->required()
                                            ->email()
                                            ->label('Email (used to login)')
                                            ->rule(function ($get, $livewire) {
                                                return function (string $attribute, $value, $fail) use ($livewire) {
                                                    $record = $livewire->record ?? null;

                                                    // Only validate if creating or the email has changed
                                                    if (!$record || $record->email !== $value) {
                                                        $userExists = DB::table('users')->where('email', $value)->exists();
                                                        $subcardExists = DB::table('subcards')->where('email', $value)->exists();

                                                        if ($userExists || $subcardExists) {
                                                            $fail("The email '$value' is already taken.");
                                                        }
                                                    }
                                                };
                                            }),

                                        Forms\Components\Select::make('partnership_level')
                                            ->label('Partnership Level')
                                            ->searchable()
                                            ->preload()
                                            ->reactive()
                                            ->default(NULL)
                                            ->options([
                                                'default' => 'Default - 10%',
                                                'leader' => 'Leader - 20%',
                                                'junior' => 'Junior - 25%',
                                                'senior' => 'Senior - 50%',
                                            ])
                                            ->disabled(fn(callable $get) => !in_array($get('user_type'), ['Gold', 'Platinum'])),

                                        Forms\Components\Select::make('sponsor_id')
                                            ->label('Sponsor Name')
                                            ->relationship('sponsor', 'sponsor_name')
                                            ->searchable()
                                            ->preload()
                                            ->reactive()
                                            ->visible(fn(callable $get) => $get('user_type') === 'Sponsored')
                                            ->disabled(fn(callable $get) => $get('user_type') !== 'Sponsored')
                                            ->rules([
                                                fn(Get $get): Closure => function (string $attribute, $value, Closure $fail) use ($get) {
                                                    if ($get('user_type') === 'Sponsored' && empty($value)) {
                                                        $fail("The sponsor is required when the card type is Sponsored.");
                                                    }
                                                },
                                            ])
                                            ->required(fn(Get $get) => $get('user_type') === 'Sponsored')
                                            ->validationMessages([
                                                'required' => 'The sponsor is required when the card type is Sponsored.',
                                            ]),

                                        Forms\Components\Select::make('country')
                                            ->required()
                                            ->searchable()
                                            ->options([
                                                'United States' => 'United States',
                                                'Philippines' => 'Philippines',
                                                'Afghanistan' => 'Afghanistan',
                                                'Albania' => 'Albania',
                                                'Algeria' => 'Algeria',
                                                'Andorra' => 'Andorra',
                                                'Angola' => 'Angola',
                                                'Antigua and Barbuda' => 'Antigua and Barbuda',
                                                'Argentina' => 'Argentina',
                                                'Australia' => 'Australia',
                                                'Austria' => 'Austria',
                                                'Azerbaijan' => 'Azerbaijan',
                                                'Bahamas' => 'Bahamas',
                                                'Bahrain' => 'Bahrain',
                                                'Bangladesh' => 'Bangladesh',
                                                'Barbados' => 'Barbados',
                                                'Belarus' => 'Belarus',
                                                'Belgium' => 'Belgium',
                                                'Belize' => 'Belize',
                                                'Benin' => 'Benin',
                                                'Bhutan' => 'Bhutan',
                                                'Bolivia' => 'Bolivia',
                                                'Bosnia and Herzegovina' => 'Bosnia and Herzegovina',
                                                'Botswana' => 'Botswana',
                                                'Brazil' => 'Brazil',
                                                'Brunei' => 'Brunei',
                                                'Bulgaria' => 'Bulgaria',
                                                'Burkina Faso' => 'Burkina Faso',
                                                'Burundi' => 'Burundi',
                                                'Cabo Verde' => 'Cabo Verde',
                                                'Cambodia' => 'Cambodia',
                                                'Cameroon' => 'Cameroon',
                                                'Canada' => 'Canada',
                                                'Central African Republic' => 'Central African Republic',
                                                'Chad' => 'Chad',
                                                'Chile' => 'Chile',
                                                'China' => 'China',
                                                'Colombia' => 'Colombia',
                                                'Comoros' => 'Comoros',
                                                'Congo (Congo-Brazzaville)' => 'Congo (Congo-Brazzaville)',
                                                'Costa Rica' => 'Costa Rica',
                                                'Croatia' => 'Croatia',
                                                'Cuba' => 'Cuba',
                                                'Cyprus' => 'Cyprus',
                                                'Czechia (Czech Republic)' => 'Czechia (Czech Republic)',
                                                'Democratic Republic of the Congo' => 'Democratic Republic of the Congo',
                                                'Denmark' => 'Denmark',
                                                'Djibouti' => 'Djibouti',
                                                'Dominica' => 'Dominica',
                                                'Dominican Republic' => 'Dominican Republic',
                                                'Ecuador' => 'Ecuador',
                                                'Egypt' => 'Egypt',
                                                'El Salvador' => 'El Salvador',
                                                'Equatorial Guinea' => 'Equatorial Guinea',
                                                'Eritrea' => 'Eritrea',
                                                'Estonia' => 'Estonia',
                                                'Eswatini (fmr. "Swaziland")' => 'Eswatini (fmr. "Swaziland")',
                                                'Ethiopia' => 'Ethiopia',
                                                'Fiji' => 'Fiji',
                                                'Finland' => 'Finland',
                                                'France' => 'France',
                                                'Gabon' => 'Gabon',
                                                'Gambia' => 'Gambia',
                                                'Georgia' => 'Georgia',
                                                'Germany' => 'Germany',
                                                'Ghana' => 'Ghana',
                                                'Greece' => 'Greece',
                                                'Grenada' => 'Grenada',
                                                'Guatemala' => 'Guatemala',
                                                'Guinea' => 'Guinea',
                                                'Guinea-Bissau' => 'Guinea-Bissau',
                                                'Guyana' => 'Guyana',
                                                'Haiti' => 'Haiti',
                                                'Holy See' => 'Holy See',
                                                'Honduras' => 'Honduras',
                                                'Hungary' => 'Hungary',
                                                'Iceland' => 'Iceland',
                                                'India' => 'India',
                                                'Indonesia' => 'Indonesia',
                                                'Iran' => 'Iran',
                                                'Iraq' => 'Iraq',
                                                'Ireland' => 'Ireland',
                                                'Israel' => 'Israel',
                                                'Italy' => 'Italy',
                                                'Jamaica' => 'Jamaica',
                                                'Japan' => 'Japan',
                                                'Jordan' => 'Jordan',
                                                'Kazakhstan' => 'Kazakhstan',
                                                'Kenya' => 'Kenya',
                                                'Kiribati' => 'Kiribati',
                                                'Kuwait' => 'Kuwait',
                                                'Kyrgyzstan' => 'Kyrgyzstan',
                                                'Laos' => 'Laos',
                                                'Latvia' => 'Latvia',
                                                'Lebanon' => 'Lebanon',
                                                'Lesotho' => 'Lesotho',
                                                'Liberia' => 'Liberia',
                                                'Libya' => 'Libya',
                                                'Liechtenstein' => 'Liechtenstein',
                                                'Lithuania' => 'Lithuania',
                                                'Luxembourg' => 'Luxembourg',
                                                'Madagascar' => 'Madagascar',
                                                'Malawi' => 'Malawi',
                                                'Malaysia' => 'Malaysia',
                                                'Maldives' => 'Maldives',
                                                'Mali' => 'Mali',
                                                'Malta' => 'Malta',
                                                'Marshall Islands' => 'Marshall Islands',
                                                'Mauritania' => 'Mauritania',
                                                'Mauritius' => 'Mauritius',
                                                'Mexico' => 'Mexico',
                                                'Micronesia' => 'Micronesia',
                                                'Moldova' => 'Moldova',
                                                'Monaco' => 'Monaco',
                                                'Mongolia' => 'Mongolia',
                                                'Montenegro' => 'Montenegro',
                                                'Morocco' => 'Morocco',
                                                'Mozambique' => 'Mozambique',
                                                'Myanmar (formerly Burma)' => 'Myanmar (formerly Burma)',
                                                'Namibia' => 'Namibia',
                                                'Nauru' => 'Nauru',
                                                'Nepal' => 'Nepal',
                                                'Netherlands' => 'Netherlands',
                                                'New Zealand' => 'New Zealand',
                                                'Nicaragua' => 'Nicaragua',
                                                'Niger' => 'Niger',
                                                'Nigeria' => 'Nigeria',
                                                'North Korea' => 'North Korea',
                                                'North Macedonia' => 'North Macedonia',
                                                'Norway' => 'Norway',
                                                'Oman' => 'Oman',
                                                'Pakistan' => 'Pakistan',
                                                'Palau' => 'Palau',
                                                'Palestine State' => 'Palestine State',
                                                'Panama' => 'Panama',
                                                'Papua New Guinea' => 'Papua New Guinea',
                                                'Paraguay' => 'Paraguay',
                                                'Peru' => 'Peru',
                                                'Poland' => 'Poland',
                                                'Portugal' => 'Portugal',
                                                'Qatar' => 'Qatar',
                                                'Romania' => 'Romania',
                                                'Russia' => 'Russia',
                                                'Rwanda' => 'Rwanda',
                                                'Saint Kitts and Nevis' => 'Saint Kitts and Nevis',
                                                'Saint Lucia' => 'Saint Lucia',
                                                'Saint Vincent and the Grenadines' => 'Saint Vincent and the Grenadines',
                                                'Samoa' => 'Samoa',
                                                'San Marino' => 'San Marino',
                                                'Sao Tome and Principe' => 'Sao Tome and Principe',
                                                'Saudi Arabia' => 'Saudi Arabia',
                                                'Senegal' => 'Senegal',
                                                'Serbia' => 'Serbia',
                                                'Seychelles' => 'Seychelles',
                                                'Sierra Leone' => 'Sierra Leone',
                                                'Singapore' => 'Singapore',
                                                'Slovakia' => 'Slovakia',
                                                'Slovenia' => 'Slovenia',
                                                'Solomon Islands' => 'Solomon Islands',
                                                'Somalia' => 'Somalia',
                                                'South Africa' => 'South Africa',
                                                'South Korea' => 'South Korea',
                                                'South Sudan' => 'South Sudan',
                                                'Spain' => 'Spain',
                                                'Sri Lanka' => 'Sri Lanka',
                                                'Sudan' => 'Sudan',
                                                'Suriname' => 'Suriname',
                                                'Sweden' => 'Sweden',
                                                'Switzerland' => 'Switzerland',
                                                'Syria' => 'Syria',
                                                'Tajikistan' => 'Tajikistan',
                                                'Tanzania' => 'Tanzania',
                                                'Thailand' => 'Thailand',
                                                'Timor-Leste' => 'Timor-Leste',
                                                'Togo' => 'Togo',
                                                'Tonga' => 'Tonga',
                                                'Trinidad and Tobago' => 'Trinidad and Tobago',
                                                'Tunisia' => 'Tunisia',
                                                'Turkey' => 'Turkey',
                                                'Turkmenistan' => 'Turkmenistan',
                                                'Tuvalu' => 'Tuvalu',
                                                'Uganda' => 'Uganda',
                                                'Ukraine' => 'Ukraine',
                                                'United Arab Emirates' => 'United Arab Emirates',
                                                'United Kingdom' => 'United Kingdom',
                                                'Uruguay' => 'Uruguay',
                                                'Uzbekistan' => 'Uzbekistan',
                                                'Vanuatu' => 'Vanuatu',
                                                'Venezuela' => 'Venezuela',
                                                'Vietnam' => 'Vietnam',
                                                'Yemen' => 'Yemen',
                                                'Zambia' => 'Zambia',
                                                'Zimbabwe' => 'Zimbabwe',
                                            ])
                                            ->reactive()
                                            ->afterStateUpdated(fn($state, $set, $livewire) => $livewire->fetchStates($state)),

                                        Forms\Components\Select::make('state')
                                            ->label('State / Region')
                                            ->searchable()
                                            ->reactive()
                                            ->options(fn($get, $livewire) => $livewire->availableStates ?? [])
                                            ->disabled(fn($get, $livewire) => empty($livewire->availableStates)),

                                        Forms\Components\Select::make('access')
                                            ->label('Access')
                                            ->columnSpanFull()
                                            ->reactive() // ✅ Required to trigger dependent field updates
                                            ->hidden(fn(callable $get) => in_array($get('user_type'), ['', 'Free']))
                                            ->helperText('Custom | Trial (' . app(\App\Settings\CardDefaultsSetting::class)->free_trial_duration . ' days) | Month (Paid for a month) | Year (Paid for a year) | Lifetime (Paid for lifetime)')
                                            ->options([
                                                'Custom' => 'Custom',
                                                'Trial' => 'Trial (' . app(\App\Settings\CardDefaultsSetting::class)->free_trial_duration . ' days)',
                                                'Month' => 'Month',
                                                'Year' => 'Year',
                                                'Lifetime' => 'Lifetime',
                                            ]),

                                        Forms\Components\TextInput::make('custom_trial')
                                            ->label('Day(s)')
                                            ->numeric()
                                            ->reactive()
                                            ->columnSpanFull()
                                            ->visible(fn(callable $get) => $get('access') === 'Custom') // ✅ show/hide logic
                                            ->required(fn(callable $get) => $get('access') === 'Custom'), // ✅ make required only if visible

                                        Forms\Components\Toggle::make('is_active')
                                            ->label('Account Active')
                                            ->default(true)
                                            ->required(),
                                    ])->columns(2),

                                Forms\Components\Section::make('Personal Details')
                                    ->description('Manage personal details here')
                                    ->schema([
                                        FileUpload::make('profile_pic')
                                            ->reactive()
                                            ->label('Upload Profile Picture')
                                            ->placeholder('Upload Profile Picture')
                                            ->directory('profile_pic')
                                            ->uploadingMessage('Uploading Profile Picture. Please wait...')
                                            ->image()
                                            ->imageEditor()
                                            ->columnSpanFull()
                                            ->imageResizeMode('cover')
                                            ->imageCropAspectRatio('1:1')
                                            ->imageResizeTargetWidth('520')
                                            ->imageResizeTargetHeight('520')
                                            ->getUploadedFileNameForStorageUsing(
                                                fn(TemporaryUploadedFile $file): string =>
                                                (string) Str::random(40) . '.' . $file->getClientOriginalExtension()
                                            )
                                            ->imageEditorAspectRatios([
                                                '1:1',
                                            ]),

                                        // Thumbnail
                                        FileUpload::make('thumbnail')
                                            ->label('Upload Custom Thumbnail')
                                            ->placeholder('Upload Custom Thumbnail')
                                            ->directory('thumbnails')
                                            ->uploadingMessage('Uploading Custom Thumbnail. Please wait...')
                                            ->image()
                                            ->imageEditor()
                                            ->columnSpanFull()
                                            ->imageResizeMode('cover')
                                            ->imageCropAspectRatio('1:1')
                                            ->imageResizeTargetWidth('520')
                                            ->imageResizeTargetHeight('520')
                                            ->getUploadedFileNameForStorageUsing(
                                                fn(TemporaryUploadedFile $file): string =>
                                                (string) Str::random(40) . '.' . $file->getClientOriginalExtension()
                                            )
                                            ->imageEditorAspectRatios([
                                                '1:1',
                                            ])
                                            ->reactive()
                                            ->hidden(fn(callable $get) => $get('user_type') == 'Free' || $get('user_type') == null),

                                        FileUpload::make('cover_pic')
                                            ->reactive()
                                            ->afterStateUpdated(function (callable $set, callable $get, $state) {
                                                // Only set profile_layout if it's not already manually changed
                                                if (!empty($state)) {
                                                    $set('profile_layout', 'default_cover');
                                                }
                                            })
                                            ->label('Upload Cover Picture')
                                            ->placeholder('Upload Cover Picture')
                                            ->directory('cover_pic')
                                            ->uploadingMessage('Uploading Cover Picture. Please wait...')
                                            ->image()
                                            ->imageEditor()
                                            ->columnSpanFull()
                                            ->imageResizeMode('cover')
                                            ->imageCropAspectRatio('1080:600')
                                            ->imageResizeTargetWidth('1080')
                                            ->imageResizeTargetHeight('600')
                                            ->getUploadedFileNameForStorageUsing(
                                                fn(TemporaryUploadedFile $file): string =>
                                                (string) Str::random(40) . '.' . $file->getClientOriginalExtension()
                                            )
                                            ->imageEditorAspectRatios([
                                                '1080:600',
                                            ])
                                            ->reactive()
                                            ->hidden(fn(callable $get) => $get('user_type') == 'Free' || $get('user_type') == null),

                                        Forms\Components\TextInput::make('firstname')
                                            ->required()
                                            ->maxLength(255)
                                            ->default(null),
                                        Forms\Components\TextInput::make('lastname')
                                            ->required()
                                            ->maxLength(255)
                                            ->default(null),

                                        Forms\Components\Select::make('gender')
                                            ->required()
                                            ->options([
                                                'Male' => 'Male',
                                                'Female' => 'Female'
                                            ]),

                                        Forms\Components\TextInput::make('phone')
                                            ->required()
                                            ->maxLength(20)
                                            ->default(null),
                                    ])->columns(2),

                                Forms\Components\Section::make('Occupation Details')
                                    ->description('Manage occupation details here')
                                    ->schema([
                                        Forms\Components\TextInput::make('job_title')
                                            ->required()
                                            ->maxLength(200)
                                            ->default(null),

                                        Forms\Components\TextInput::make('company')
                                            ->maxLength(255)
                                            ->default(null),

                                        Forms\Components\TextInput::make('company_website')
                                            ->maxLength(255)
                                            ->url()
                                            ->columnSpanFull()
                                            ->default(null),

                                        Forms\Components\Textarea::make('bio')
                                            ->maxLength(200)
                                            ->columnSpanFull()
                                            ->helperText('Write a few sentences about yourself. Max character 200.'),


                                        // TinyEditor::make('bio_long')
                                        //     ->visible(fn(callable $get) => in_array($get('user_type') ?? null, ['Sponsored', 'Gold', 'Platinum']))
                                        //     ->label('Long Bio')
                                        //     ->profile('custom') // define this profile in config
                                        //     ->reactive(false)
                                        //     // ->live()
                                        //     ->columnSpan('full')
                                        //     ->helperText('Write your bio. Max character 5000.')
                                        //     ->afterStateUpdated(function ($state, $set) {
                                        //         $plainText = strip_tags($state ?? '');
                                        //         $set('bio_long_count', Str::length($plainText)); // keep server-side fallback
                                        //     })
                                        //     ->extraAttributes(['wire:model.defer' => 'bio_long'])
                                        //     ->extraAttributes(['wire:ignore'])
                                        //     ->rule(fn($get) => function ($attribute, $value, $fail) {
                                        //         $plainText = strip_tags($value ?? '');
                                        //         if (Str::length($plainText) > 5000) {
                                        //             $fail('The long bio must not exceed 5000 characters.');
                                        //         }
                                        //     }),

                                        // FilamentLexicalEditor::make('bio_long')
                                        //     ->columnSpanFull()
                                        //     ->reactive()
                                        //     ->live()
                                        //     ->visible(fn(callable $get) => in_array($get('user_type') ?? null, ['Sponsored', 'Gold', 'Platinum']))
                                        //     ->label('Long Bio')
                                        //     ->enabledToolbars([
                                        //         // ToolbarItem::UNDO,
                                        //         // ToolbarItem::REDO,
                                        //         ToolbarItem::BOLD,
                                        //         ToolbarItem::ITALIC,
                                        //         ToolbarItem::UNDERLINE,
                                        //         ToolbarItem::LEFT,
                                        //         ToolbarItem::CENTER,
                                        //         ToolbarItem::RIGHT,
                                        //         ToolbarItem::JUSTIFY,
                                        //         ToolbarItem::START,
                                        //         ToolbarItem::END,
                                        //         ToolbarItem::BULLET,
                                        //         ToolbarItem::NUMBERED,
                                        //     ])
                                        //     ->helperText('Write your bio. Max character 5000.')
                                        //     ->afterStateUpdated(function ($state, $set) {
                                        //         $plainText = strip_tags($state ?? '');
                                        //         $set('bio_long_count', Str::length($plainText)); // keep server-side fallback
                                        //     })
                                        //     ->extraAttributes(['wire:model.defer' => 'bio_long'])
                                        //     ->extraAttributes(['wire:ignore'])
                                        //     ->rule(fn($get) => function ($attribute, $value, $fail) {
                                        //         $plainText = strip_tags($value ?? '');
                                        //         if (Str::length($plainText) > 5000) {
                                        //             $fail('The long bio must not exceed 5000 characters.');
                                        //         }
                                        //     }),

                                        // FilamentLexicalEditor::make('bio_long')
                                        //     ->columnSpanFull()
                                        //     ->reactive()
                                        //     ->live()
                                        //     ->label('Long Bio')
                                        //     ->hidden(fn(callable $get) => !in_array($get('user_type') ?? null, ['Sponsored', 'Gold', 'Platinum']))
                                        //     ->enabledToolbars([
                                        //         ToolbarItem::BOLD,
                                        //         ToolbarItem::ITALIC,
                                        //         ToolbarItem::UNDERLINE,
                                        //         ToolbarItem::LEFT,
                                        //         ToolbarItem::CENTER,
                                        //         ToolbarItem::RIGHT,
                                        //         ToolbarItem::JUSTIFY,
                                        //         ToolbarItem::BULLET,
                                        //         ToolbarItem::NUMBERED,
                                        //     ])
                                        //     ->helperText('Write your bio. Max character 5000.')
                                        //     ->afterStateUpdated(function ($state, $set) {
                                        //         $plainText = strip_tags($state ?? '');
                                        //         $set('bio_long_count', Str::length($plainText));
                                        //     })

                                        //     ->rule(fn($get) => function ($attribute, $value, $fail) {
                                        //         $plainText = strip_tags($value ?? '');
                                        //         if (Str::length($plainText) > 5000) {
                                        //             $fail('The long bio must not exceed 5000 characters.');
                                        //         }
                                        //     }),

                                        // Live character counter
                                        // ViewField::make('bio_long_count')
                                        //     ->hidden(fn(callable $get) => !in_array($get('user_type') ?? null, ['Sponsored', 'Gold', 'Platinum']))
                                        //     ->view('forms.bio-long-counter')
                                        //     ->reactive(false)
                                        //     ->columnSpan('full'),


                                        // FilamentLexicalEditor::make('bio_long')
                                        //     ->columnSpanFull()
                                        //     ->label('Long Bio')
                                        //     ->visible(
                                        //         fn(callable $get) =>
                                        //         in_array($get('user_type'), ['Sponsored', 'Gold', 'Platinum'])
                                        //     )
                                        //     ->enabledToolbars([
                                        //         ToolbarItem::BOLD,
                                        //         ToolbarItem::ITALIC,
                                        //         ToolbarItem::UNDERLINE,
                                        //         ToolbarItem::LINK,
                                        //         ToolbarItem::LEFT,
                                        //         ToolbarItem::CENTER,
                                        //         ToolbarItem::RIGHT,
                                        //         ToolbarItem::JUSTIFY,
                                        //         ToolbarItem::BULLET,
                                        //         ToolbarItem::NUMBERED,
                                        //         // ToolbarItem::FONT_SIZE,   // hide visually but keeps ref
                                        //         // ToolbarItem::FONT_FAMILY,
                                        //     ])

                                        //     ->helperText('Write your bio. Max character 5000.')

                                        //     // Load count on first load
                                        //     ->afterStateHydrated(function ($state, $set) {
                                        //         $plainText = strip_tags($state ?? '');
                                        //         $set('bio_long_count', Str::length($plainText));
                                        //     })

                                        //     // Update counter on typing
                                        //     ->afterStateUpdated(function ($state, $set) {
                                        //         $plainText = strip_tags($state ?? '');
                                        //         $set('bio_long_count', Str::length($plainText));
                                        //     })

                                        //     // Validation rule
                                        //     ->rule(fn($get) => function ($attribute, $value, $fail) {
                                        //         $plainText = strip_tags($value ?? '');
                                        //         if (Str::length($plainText) > 5000) {
                                        //             $fail('The long bio must not exceed 5000 characters.');
                                        //         }
                                        //     }),


                                        // RichEditor::make('bio_long')
                                        //     ->label('Long Bio')
                                        //     ->columnSpanFull()

                                        //     // Only show for these user types
                                        //     ->hidden(fn($get) => ! in_array(
                                        //         $get('user_type'),
                                        //         ['Sponsored', 'Gold', 'Platinum']
                                        //     ))

                                        //     // Optional: restrict toolbar items
                                        //     ->toolbarButtons([
                                        //         'bold',
                                        //         'italic',
                                        //         'underline',
                                        //         'link',
                                        //         'bulletList',
                                        //         'orderedList',
                                        //     ])

                                        //     ->placeholder('Write your bio here...')
                                        //     ->helperText('Max 5000 characters.')

                                        //     // Load initial character count
                                        //     ->afterStateHydrated(function ($state, $set) {
                                        //         $plain = strip_tags($state ?? '');
                                        //         $set('bio_long_count', Str::length($plain));
                                        //     })

                                        //     // Update count on typing
                                        //     ->afterStateUpdated(function ($state, $set) {
                                        //         $plain = strip_tags($state ?? '');
                                        //         $set('bio_long_count', Str::length($plain));
                                        //     })

                                        //     // Validation rule
                                        //     ->rule(function () {
                                        //         return function ($attribute, $value, $fail) {
                                        //             if (Str::length(strip_tags($value ?? '')) > 5000) {
                                        //                 $fail('The long bio must not exceed 5000 characters.');
                                        //             }
                                        //         };
                                        //     }),


                                        CKEditor::make('bio_long')
                                            ->label('Long Bio')
                                            ->columnSpanFull()

                                            // Only visible for these user types
                                            ->hidden(fn($get) => ! in_array($get('user_type'), ['Sponsored', 'Gold', 'Platinum']))

                                            ->placeholder('Write your bio here...')
                                            ->helperText('Max 5000 characters.')
                                            // Character counter initial load
                                            ->afterStateHydrated(function ($state, $set) {
                                                $plain = strip_tags($state ?? '');
                                                $set('bio_long_count', Str::length($plain));
                                            })

                                            // Update counter on typing
                                            ->afterStateUpdated(function ($state, $set) {
                                                $plain = strip_tags($state ?? '');
                                                $set('bio_long_count', Str::length($plain));
                                            })

                                            // Validation rule
                                            ->rule(function () {
                                                return function ($attribute, $value, $fail) {
                                                    $plain = strip_tags($value ?? '');
                                                    if (Str::length($plain) > 5000) {
                                                        $fail('The long bio must not exceed 5000 characters.');
                                                    }
                                                };
                                            }),

                                        // ViewField::make('bio_long_alignment')
                                        //     ->view('forms.bio-long-alignment-buttons') // we’ll create this file next
                                        //     ->columnSpanFull(),

                                        ViewField::make('bio_long_count')
                                            ->hidden(
                                                fn(callable $get) =>
                                                !in_array($get('user_type') ?? null, ['Sponsored', 'Gold', 'Platinum'])
                                            )
                                            ->view('forms.bio-long-counter')
                                            ->columnSpanFull(),


                                    ])->columns(2),
                            ]),
                        Tabs\Tab::make('Content')
                            ->visible(fn(callable $get) => in_array($get('user_type'), ['Sponsored', 'Influencer', 'Basic', 'Gold', 'Platinum']))
                            ->schema([
                                // Related UserSettings fields
                                Forms\Components\Section::make('Card Contents')
                                    ->schema([
                                        Forms\Components\Select::make('profile_layout')
                                            ->columnSpanFull()
                                            ->label('Profile Picture Layout')
                                            ->default('default')
                                            ->reactive()
                                            ->options([
                                                'default' => 'Default',
                                                'rounded' => 'Rounded',
                                                'default_cover' => 'With Cover',
                                                'full_width' => 'Full Width',
                                                'cover_only' => 'Cover Only',
                                            ]),
                                        TextInput::make('card_custom_title')
                                            ->label('Display Name')
                                            ->columnSpanFull()
                                            ->placeholder('Default will be the fullname'),
                                        TextInput::make('custom_page_title')
                                            ->columnSpanFull()
                                            ->placeholder('Default will be the custom display name or fullname')
                                            ->label('Page Title'),
                                    ]),

                                Forms\Components\Section::make('Gallery')
                                    ->schema([
                                        Forms\Components\Toggle::make('gallery_two_slide')
                                            ->label('Gallery 2 images per slide')
                                            ->default(true),
                                    ]),

                                Forms\Components\Section::make('Custom Text')
                                    ->schema([
                                        TextInput::make('contact_text')
                                            ->default('Contact me')
                                            ->label('Contact Text'),

                                        TextInput::make('follow_text')
                                            ->default('Follow me')
                                            ->label('Follow Text'),

                                        // TextInput::make('bio_text')
                                        //     ->default('My Bio')
                                        //     ->label('Bio Text'),

                                        TextInput::make('event_text')
                                            ->default('Events')
                                            ->label('Events Text'),

                                        TextInput::make('payment_text')
                                            ->default('Payments')
                                            ->label('Payment Links'),

                                    ])->columns(2),

                                //Click here (Videos)
                                Forms\Components\Section::make('Click here (Videos)')
                                    ->schema([
                                        TextInput::make('click_videos')
                                            ->label('Button Text')
                                            ->default('Click here'),

                                        TextInput::make('click_videos_link')
                                            ->label('Button Link'),

                                    ])->columns(2),

                                //Click here (Gallery)
                                Forms\Components\Section::make('Click here (Gallery)')
                                    ->schema([
                                        TextInput::make('click_gallery')
                                            ->label('Button Text')
                                            ->default('Click here'),

                                        TextInput::make('click_gallery_link')
                                            ->label('Button Link'),

                                    ])->columns(2),

                                Forms\Components\Section::make('Footer Content')
                                    ->schema([
                                        TextInput::make('footer_text')
                                            // ->required()
                                            ->label('Footer Link Text')
                                            ->default(app(CardDefaultsSetting::class)->footer_text),

                                        TextInput::make('footer_link')
                                            // ->required()
                                            ->label('Footer Link'),

                                    ])->columns(2),

                                Forms\Components\Section::make('Shop')
                                    ->visible(fn(callable $get) => !in_array($get('user_type'), ['Sponsored', 'Influencer', 'Free', 'Basic']))
                                    ->schema([
                                        TextInput::make('shop_text')
                                            ->label('Shop Title'),

                                        TextInput::make('shop_more')
                                            ->label('Shop More URL')
                                            ->url(),

                                        FileUpload::make('shop_thumbnail')
                                            ->label('Shop Thumbnail')
                                            ->placeholder('Upload Shop Thumbnail')
                                            ->directory('thumbnails')
                                            ->uploadingMessage('Uploading Custom Thumbnail. Please wait...')
                                            ->image()
                                            ->imageEditor()
                                            ->multiple(false) // ✅ only one image
                                            ->columnSpanFull()
                                            ->imageResizeMode('cover')
                                            ->imageCropAspectRatio('1:1')
                                            ->imageResizeTargetWidth('520')
                                            ->imageResizeTargetHeight('520')
                                            ->getUploadedFileNameForStorageUsing(
                                                fn(TemporaryUploadedFile $file): string =>
                                                (string) Str::random(40) . '.' . $file->getClientOriginalExtension()
                                            )
                                            ->imageEditorAspectRatios([
                                                '1:1',
                                            ]),
                                    ]),

                                Forms\Components\Section::make('Services')
                                    ->visible(fn(callable $get) => !in_array($get('user_type'), ['Sponsored', 'Influencer', 'Free', 'Basic']))
                                    ->schema([
                                        TextInput::make('services_text')
                                            ->label('Services Button Title'),
                                    ]),
                            ]),

                        Tabs\Tab::make('Theme')
                            ->visible(fn(callable $get) => in_array($get('user_type'), ['Sponsored', 'Influencer', 'Basic', 'Gold', 'Platinum']))
                            ->schema([

                                Forms\Components\Select::make('preset')
                                    ->helperText('Select color preset or customize')
                                    ->label('Select Preset')
                                    ->options(function () {
                                        return ColorPreset::pluck('title', 'id')->toArray() + ['Custom' => 'Custom'];
                                    })
                                    ->reactive()
                                    ->afterStateUpdated(function ($state, callable $set) {
                                        if ($state === 'Custom') {
                                            return; // do not auto-fill
                                        }

                                        $preset = \App\Models\ColorPreset::find($state);
                                        if (! $preset) return;

                                        $set('color_settings_custom_button', $preset->custom_button);
                                        $set('color_settings_custom_button_text', $preset->custom_button_text);
                                        $set('color_settings_link', $preset->link);
                                        $set('color_settings_profile_pic_border', $preset->profile_pic_border);
                                        $set('color_settings_card_light', $preset->card_light);
                                        $set('color_settings_card_dark', $preset->card_dark);
                                        $set('color_settings_text_light', $preset->text_light);
                                        $set('color_settings_text_dark', $preset->text_dark);
                                    }),

                                Forms\Components\Section::make('Custom')
                                    ->visible(fn(callable $get) => $get('preset') == 'Custom')
                                    ->schema([
                                        ColorPicker::make('color_settings_custom_button')
                                            ->label('Button Color')
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#facc15'),

                                        ColorPicker::make('color_settings_custom_button_text')
                                            ->label('Button Text Color')
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#000000'),

                                        ColorPicker::make('color_settings_link')
                                            ->label('Link Color')
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#ca8a04'),

                                        ColorPicker::make('color_settings_profile_pic_border')
                                            ->label('Profile Pic Border Color')
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#ca8a04'),

                                        ColorPicker::make('color_settings_card_light')
                                            ->label('Light Mode Background Color')
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#ffffff'),

                                        ColorPicker::make('color_settings_card_dark')
                                            ->label('Dark Mode Background Color')
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#18181b'),

                                        ColorPicker::make('color_settings_text_light')
                                            ->label('Light Mode Font Color')
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#1e293b'),

                                        ColorPicker::make('color_settings_text_dark')
                                            ->label('Dark Mode Font Color')
                                            ->regex('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i')
                                            ->default('#cbd5e1'),
                                    ])->columns(2),

                                Forms\Components\Select::make('button_style')
                                    ->label('Button Style')
                                    ->options([
                                        'rounded' => 'Rounded',
                                        'squared' => 'Squared',
                                    ]),
                            ]),

                        Tabs\Tab::make('Visibility')
                            ->schema([
                                Forms\Components\Toggle::make('searchable')
                                    ->label('Search Visibility')
                                    ->default(true),

                                Forms\Components\Toggle::make('display_username')
                                    ->label('Username Handle')
                                    ->default(true),

                                Forms\Components\Toggle::make('display_short_bio')
                                    ->label('Short Bio')
                                    ->default(true),

                                Forms\Components\Toggle::make('display_country')
                                    ->label('Country')
                                    ->default(true),

                                Forms\Components\Toggle::make('connect_main')
                                    ->visible(fn(callable $get) => $get('user_type') != 'Free')
                                    ->label("Let's Connect (Main Card)")
                                    ->default(true),

                                Forms\Components\Toggle::make('connect_bio')
                                    ->visible(fn(callable $get) => $get('user_type') != 'Free')
                                    ->label("Let's Connect (Bio Page)")
                                    ->default(false),

                                Forms\Components\Toggle::make('gallery_main')
                                    ->visible(fn(callable $get) => in_array($get('user_type'), ['Gold', 'Platinum']))
                                    ->label("Gallery (Main Card)")
                                    ->default(true),

                                Forms\Components\Toggle::make('gallery_bio')
                                    ->visible(fn(callable $get) => in_array($get('user_type'), ['Gold', 'Platinum']))
                                    ->label("Gallery (Bio Page)")
                                    ->default(false),

                                Forms\Components\Toggle::make('product_price_enabled')
                                    ->visible(fn(callable $get) => in_array($get('user_type'), ['Gold', 'Platinum']))
                                    ->label("Product Price")
                                    ->default(true),

                                Forms\Components\Toggle::make('services_price_enabled')
                                    ->visible(fn(callable $get) => in_array($get('user_type'), ['Gold', 'Platinum']))
                                    ->label("Services Price")
                                    ->default(true),

                                Forms\Components\Toggle::make('click_videos_enabled')
                                    ->visible(fn(callable $get) => in_array($get('user_type'), ['Gold', 'Platinum']))
                                    ->label("Click here (Videos)")
                                    ->default(false),

                                Forms\Components\Toggle::make('click_gallery_enabled')
                                    ->visible(fn(callable $get) => in_array($get('user_type'), ['Gold', 'Platinum']))
                                    ->label("Click here (Gallery)")
                                    ->default(false),

                                Forms\Components\Toggle::make('getacard_enabled')
                                    ->visible(fn(callable $get) => in_array($get('user_type'), ['Gold', 'Platinum']))
                                    ->label('"Get a card like this" Button')
                                    ->default(false),

                                Forms\Components\Toggle::make('footer_enabled')
                                    ->visible(fn(callable $get) => $get('user_type') != 'Free')
                                    ->label("Footer")
                                    ->default(true),
                            ]),
                    ])
                    ->activeTab(1)
                    ->columnSpanFull()
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([

                Tables\Columns\ToggleColumn::make('is_active')
                    ->label('Active')
                    ->onColor('success') // ✅ green when active
                    ->offColor('danger'), // ❌ red when inactive

                Tables\Columns\TextColumn::make('user_type')
                    ->badge()
                    ->label('Card Type')
                    ->getStateUsing(fn($record) => $record->user_type ?? 'setup_incomplete')
                    ->formatStateUsing(function ($state) {
                        // return $state === 'setup_incomplete' ? 'Setup Incomplete' : $state;

                        $settings = app(CardDefaultsSetting::class);

                        return match ($state) {
                            'Basic' => $settings->term_basic,
                            'Gold' => $settings->term_gold,
                            'Platinum' => $settings->term_platinum,
                            'setup_incomplete' => 'Setup Incomplete',
                            default => $state,
                        };
                    })
                    ->color(function ($state) {
                        return match ($state) {
                            'Free' => 'info',
                            'Basic' => 'success',
                            'Gold' => 'warning',
                            'Platinum' => 'gray',
                            'Sponsored' => 'danger',
                            'Influencer' => 'influencer',
                            'setup_incomplete' => 'indigo',
                        };
                    }),

                Tables\Columns\TextColumn::make('username')
                    ->badge()
                    ->label('Card Link')
                    ->color('primary')
                    ->searchable(query: function ($query, $search) {
                        $query->orWhere('username', 'like', '%' . ltrim($search, '@') . '%');
                    })
                    ->url(function ($record) {
                        $siteUrl = app(CardDefaultsSetting::class)->site_url;
                        return "{$siteUrl}{$record->username}";
                    })
                    ->formatStateUsing(fn($state) => '@' . $state)
                    ->openUrlInNewTab(),

                Tables\Columns\TextColumn::make('email')
                    ->searchable()
                    ->label('Email'),

                Tables\Columns\TextColumn::make('firstname')
                    ->label('Client')
                    ->getStateUsing(function ($record) {
                        return $record ? $record->firstname . ' ' . $record->lastname : 'N/A';
                    })
                    // ->sortable()
                    ->searchable(['firstname', 'lastname']),

                Tables\Columns\TextColumn::make('created_at')
                    ->label('Created')
                    ->sortable()
                    ->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y')),
                // ->formatStateUsing(fn($state) => Carbon::parse($state)->format('M d, Y | D | h:i a')),

            ])
            ->defaultSort('created_at', 'desc')
            ->filters([
                //
                Filter::make('is_active')
                    ->label('Active')
                    ->query(fn(Builder $query) => $query->where('is_active', true)),

                Filter::make('user_type_null')
                    ->label('Setup Incomplete')
                    ->query(fn($query) => $query->whereNull('user_type')),

                SelectFilter::make('user_type')
                    ->label('User Type')
                    ->options(function () {
                        $settings = app(CardDefaultsSetting::class);

                        return [
                            'Free' => 'Free',
                            'Basic' => $settings->term_basic,
                            'Gold' => $settings->term_gold,
                            'Platinum' => $settings->term_platinum,
                            'Sponsored' => 'Sponsored',
                            'Influencer' => 'Influencer',
                        ];
                    }),
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    // Tables\Actions\ViewAction::make(),
                    Tables\Actions\Action::make('view_card')
                        ->label('View')
                        ->icon('heroicon-o-eye')
                        ->url(fn($record) => app(CardDefaultsSetting::class)->site_url . $record->username)
                        ->openUrlInNewTab()
                        ->color('info'),
                    Tables\Actions\EditAction::make(),

                    Tables\Actions\Action::make('customAction')
                        ->icon('heroicon-o-document-duplicate')
                        ->label('Duplicate')
                        ->color('warning')
                        ->action(function (Model $record) {
                            DB::transaction(function () use ($record) {

                                $duplicateFile = function (?string $filePath) {
                                    if (!$filePath || !Storage::disk('public')->exists($filePath)) {
                                        return null;
                                    }

                                    $directory = dirname($filePath); // e.g. profile_pic
                                    $extension = pathinfo($filePath, PATHINFO_EXTENSION);
                                    $originalName = pathinfo($filePath, PATHINFO_FILENAME);

                                    // Limit the original name length to avoid filesystem errors
                                    $maxBaseLength = 50; // adjust as needed (e.g. 50 chars)
                                    $shortName = Str::limit($originalName, $maxBaseLength, '');

                                    $newFileName = $shortName . '_' . Str::random(6) . '.' . $extension;
                                    $newPath = $directory . '/' . $newFileName;

                                    Storage::disk('public')->makeDirectory($directory);
                                    Storage::disk('public')->copy($filePath, $newPath);

                                    return $newPath;
                                };

                                // Duplicate logic here
                                $newRecord = $record->replicate(); // Clone the record

                                // Modify unique fields to avoid conflicts
                                $newRecord->username = $record->username . '_' . uniqid(); // Add random suffix
                                $newRecord->email = uniqid() . '_' . $record->email; // Or generate a dummy email if needed

                                // Duplicate each image to its respective folder
                                $newRecord->thumbnail = $duplicateFile($record->thumbnail);
                                $newRecord->profile_pic = $duplicateFile($record->profile_pic);
                                $newRecord->cover_pic = $duplicateFile($record->cover_pic);

                                //dont replicate the following
                                $newRecord->phone = NULL;
                                $newRecord->email = NULL;
                                $newRecord->created_at = Carbon::now();
                                $newRecord->updated_at = Carbon::now();

                                $newRecord->email_verified_at = NULL;
                                $newRecord->password = NULL;
                                $newRecord->firstname = NULL;
                                $newRecord->lastname = NULL;
                                $newRecord->gender = NULL;
                                $newRecord->job_title = NULL;
                                $newRecord->bio = NULL;
                                $newRecord->bio_long = NULL;
                                $newRecord->company = NULL;
                                $newRecord->company_website = NULL;
                                $newRecord->country = NULL;
                                // $newRecord->user_type = NULL;
                                $newRecord->sponsor_id = NULL;
                                $newRecord->stripe_id = NULL;
                                $newRecord->pm_type = NULL;
                                $newRecord->pm_last_four = NULL;
                                $newRecord->trial_ends_at = NULL;
                                $newRecord->access = NULL;

                                $newRecord->is_duplicated = true;

                                $newRecord->save();

                                //replicate settings
                                if ($record->settings) {
                                    foreach ($record->settings as $settings) {
                                        if (is_null($settings->page_id)) {
                                            $newSettings = $settings->replicate();
                                            $newSettings->user_id = $newRecord->id;
                                            $newSettings->save();
                                        }
                                    }
                                }

                                // Replicate buttons
                                if ($record->buttons()->exists()) {
                                    foreach ($record->buttons()->orderBy('order')->get() as $button) {
                                        // Skip buttons attached to a page
                                        if (!is_null($button->page_id)) {
                                            continue;
                                        }

                                        // Replicate the button
                                        $newButton = $button->replicate();
                                        $newButton->user_id = $newRecord->id;
                                        $newButton->order = $button->order;
                                        $newButton->save();

                                        // If it's a "team" type button, replicate its members
                                        if ($newButton->type === 'team') {
                                            foreach ($button->members as $member) {
                                                $newMember = $member->replicate();
                                                $newMember->team_id = $newButton->id;
                                                $newMember->member_id = $member->member_id;
                                                $newMember->card_type = $member->card_type;
                                                $newMember->order = $member->order;
                                                $newMember->custom_card_link = $member->custom_card_link;
                                                $newMember->save();
                                            }
                                        }
                                    }
                                }

                                //replicate socials
                                if ($record->socials) {
                                    // foreach ($record->socials as $socials) {
                                    foreach ($record->socials()->orderBy('order')->get() as $socials) {
                                        if (is_null($socials->page_id)) {
                                            $newSocials = $socials->replicate();
                                            $newSocials->user_id = $newRecord->id;
                                            $newSocials->order = $socials->order; // ✅ preserve original order
                                            $newSocials->save();
                                        }
                                    }
                                }

                                //replicate videos
                                if ($record->videos) {
                                    // foreach ($record->videos as $videos) {
                                    foreach ($record->videos()->orderBy('order')->get() as $videos) {
                                        if (is_null($videos->page_id)) {
                                            $newVideos = $videos->replicate();
                                            $newVideos->user_id = $newRecord->id;
                                            $newVideos->order = $videos->order; // ✅ preserve original order
                                            $newVideos->save();
                                        }
                                    }
                                }

                                //replicate ads
                                if ($record->ads) {
                                    // foreach ($record->ads as $ads) {
                                    foreach ($record->ads()->orderBy('order')->get() as $ads) {
                                        if (is_null($ads->page_id)) {
                                            $newAds = $ads->replicate();
                                            $newAds->image = $duplicateFile($ads->image);
                                            $newAds->user_id = $newRecord->id;
                                            $newAds->order = $ads->order; // ✅ preserve original order
                                            $newAds->save();
                                        }
                                    }
                                }

                                //replicate driving directions
                                if ($record->directions) {
                                    foreach ($record->directions()->orderBy('order')->get() as $directions) {
                                        if (is_null($directions->page_id)) {
                                            $newDirections = $directions->replicate();
                                            $newDirections->user_id = $newRecord->id;
                                            $newDirections->order = $directions->order;
                                            $newDirections->save();
                                        }
                                    }
                                }

                                // replicate products and their media
                                if ($record->products) {
                                    foreach ($record->products()->orderBy('order')->get() as $product) {
                                        if (is_null($product->page_id)) {
                                            $newProduct = $product->replicate();
                                            $newProduct->featured_image = $duplicateFile($product->featured_image);
                                            $newProduct->user_id = $newRecord->id;
                                            $newProduct->order = $product->order;
                                            $newProduct->save();

                                            // replicate associated product media
                                            if ($product->media && $product->media()->exists()) {
                                                foreach ($product->media()->orderBy('order')->get() as $media) {
                                                    $newMedia = $media->replicate();
                                                    // ✅ Only duplicate the file if it's an image
                                                    if ($media->type === 'image') {
                                                        $newPath = $duplicateFile($media->path);

                                                        // skip if file missing or invalid
                                                        if (!$newPath) {
                                                            continue;
                                                        }

                                                        $newMedia->path = $newPath;
                                                    } else {
                                                        // non-image types (video, pdf, etc.) keep the same path
                                                        $newMedia->path = $media->path;
                                                    }

                                                    $newMedia->product_id = $newProduct->id; // link to new product

                                                    $newMedia->order = $media->order;
                                                    $newMedia->save();
                                                }
                                            }
                                        }
                                    }
                                }

                                //replicate services
                                if ($record->services) {
                                    // foreach ($record->services as $services) {
                                    foreach ($record->services()->orderBy('order')->get() as $services) {
                                        if (is_null($services->page_id)) {
                                            $newServices = $services->replicate();
                                            $newServices->service_image = $duplicateFile($services->service_image);
                                            $newServices->user_id = $newRecord->id;
                                            $newServices->order = $services->order; // ✅ preserve original order
                                            $newServices->save();
                                        }
                                    }
                                }

                                //replicate images
                                if ($record->images) {
                                    // foreach ($record->images as $images) {
                                    foreach ($record->images()->orderBy('order')->get() as $images) {
                                        if (is_null($images->page_id)) {
                                            $newImages = $images->replicate();
                                            $newImages->image_path = $duplicateFile($images->image_path);
                                            $newImages->user_id = $newRecord->id;
                                            $newImages->order = $images->order; // ✅ preserve original order
                                            $newImages->save();
                                        }
                                    }
                                }

                                //replicate events
                                if ($record->events) {
                                    // foreach ($record->services as $services) {
                                    foreach ($record->events()->orderBy('order')->get() as $events) {
                                        if (is_null($events->page_id)) {
                                            $newEvents = $events->replicate();
                                            $newEvents->event_poster = $duplicateFile($events->event_poster);
                                            $newEvents->user_id = $newRecord->id;
                                            $newEvents->order = $events->order; // ✅ preserve original order
                                            $newEvents->save();
                                        }
                                    }
                                }

                                // Optional: You could redirect or notify
                                Notification::make()
                                    ->title('Success')
                                    ->body('Card duplicated successfully.')
                                    ->success()
                                    ->send();
                            });
                        }),
                    // Tables\Actions\DeleteAction::make(),

                    Action::make('sendResetLink')
                        ->label('Send Reset Link')
                        ->icon('heroicon-o-envelope')
                        ->color('warning')
                        ->requiresConfirmation()
                        ->action(function ($record) {
                            // Send password reset link
                            $status = Password::sendResetLink([
                                'email' => $record->email,
                            ]);

                            if ($status === Password::RESET_LINK_SENT) {
                                Notification::make()
                                    ->title('Reset link sent')
                                    ->body("A password reset link has been sent to {$record->email}.")
                                    ->success()
                                    ->send();
                            } else {
                                Notification::make()
                                    ->title('Error sending link')
                                    ->body(__($status))
                                    ->danger()
                                    ->send();
                            }
                        }),

                    Action::make('resendEmailConfirmation')
                        ->label('Resend Email Confirmation')
                        ->icon('heroicon-o-paper-airplane')
                        ->color('info')
                        ->visible(fn($record) => $record->user_type === NULL) // ✅ Only show for incomplete setup
                        ->requiresConfirmation()
                        ->action(function ($record) {
                            // Example: trigger your custom email confirmation logic
                            try {
                                // If you have a method or notification for confirmation email:
                                $record->sendEmailVerificationNotification(); // Laravel built-in for MustVerifyEmail trait

                                Notification::make()
                                    ->title('Confirmation email sent')
                                    ->body("A confirmation email has been sent to {$record->email}.")
                                    ->success()
                                    ->send();
                            } catch (\Exception $e) {
                                Notification::make()
                                    ->title('Error sending confirmation email')
                                    ->body($e->getMessage())
                                    ->danger()
                                    ->send();
                            }
                        }),
                ])
                    // ->dropdown(false)
                    ->label('Actions') // optional — can be hidden if you prefer
                    ->icon('heroicon-o-cog-6-tooth') // optional
                    ->color('gray'),
                // ->alignment('start'), // ✅ ensures buttons are left-aligned

            ])

            // ->bulkActions(static::getTableBulkActions());
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make(static::getTableBulkActions()),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            PagesRelationManager::class,
            ButtonsRelationManager::class,
            SocialsRelationManager::class,
            PaymentRelationManager::class,
            ContactsRelationManager::class,
            DirectionsRelationManager::class,
            CommunitiesRelationManager::class,
            ProductsRelationManager::class,
            CategoryRelationManager::class,
            ProductCollectionRelationManager::class,
            ServicesRelationManager::class,
            VideosRelationManager::class,
            AdRelationManager::class,
            ImagesRelationManager::class,
            SubcardsRelationManager::class,
            EventsRelationManager::class,
            // SalesRelationManager::class,
            TeamsRelationManager::class,
            TrustedNetworkRelationManager::class,
            ReplaysRelationManager::class,
            ReviewsRelationManager::class
        ];
    }

    public static function getWidgets(): array
    {
        return [
            UserResource\Widgets\CustomerOverview::class,
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        //will not display admin accounts
        return parent::getEloquentQuery()->where('is_admin', false);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListUsers::route('/'),
            'create' => Pages\CreateUser::route('/create'),
            'view' => Pages\ViewUser::route('/{record}'),
            'edit' => Pages\EditUser::route('/{record}/edit'),
        ];
    }
}
