<?php

namespace App\Filament\Widgets;

use App\Models\User;
use App\Models\Button;
use App\Models\SubCard;
use App\Settings\CardDefaultsSetting;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class UserStatsOverview extends BaseWidget
{
    protected static ?int $sort = 2;

    protected function getHeading(): ?string
    {
        return 'Cardholder Insights';
    }

    protected function getDescription(): ?string
    {
        return 'This is the summary of digital business card distribution. This section highlights the total number of cards created per Card Type.';
    }

    public function redirectFreeClients()
    {
        return redirect('/admin/clients?tableFilters[is_active][isActive]=false&tableFilters[user_type][value]=Free&tableSortColumn=created_at&tableSortDirection=desc');
    }

    public function redirectBasicClients()
    {
        return redirect('/admin/clients?tableFilters[is_active][isActive]=false&tableFilters[user_type][value]=Basic&tableSortColumn=created_at&tableSortDirection=desc');
    }

    public function redirectGoldClients()
    {
        return redirect('/admin/clients?tableFilters[is_active][isActive]=false&tableFilters[user_type][value]=Gold&tableSortColumn=created_at&tableSortDirection=desc');
    }

    public function redirectPlatinumClients()
    {
        return redirect('/admin/clients?tableFilters[is_active][isActive]=false&tableFilters[user_type][value]=Platinum&tableSortColumn=created_at&tableSortDirection=desc');
    }

    public function redirectSponsoredClients()
    {
        return redirect('/admin/clients?tableFilters[is_active][isActive]=false&tableFilters[user_type][value]=Sponsored&tableSortColumn=created_at&tableSortDirection=desc');
    }

    public function redirectSubCardsClients()
    {
        return redirect('/admin/sub-cards');
    }

    protected function getStats(): array
    {
        $settings = app(CardDefaultsSetting::class);
        $freeUsers = User::where('user_type', 'Free')
            ->where('is_admin', false)
            ->whereBetween('created_at', [now()->subDays(7)->startOfDay(), now()->endOfDay()])
            ->selectRaw('DATE(created_at) as date, COUNT(*) as count')
            ->groupBy('date')
            ->get()
            ->keyBy('date');

        $basicUsers = User::where('user_type', 'Basic')
            ->where('is_admin', false)
            ->whereBetween('created_at', [now()->subDays(7)->startOfDay(), now()->endOfDay()])
            ->selectRaw('DATE(created_at) as date, COUNT(*) as count')
            ->groupBy('date')
            ->get()
            ->keyBy('date');

        $goldUsers = User::where('user_type', 'Gold')
            ->where('is_admin', false)
            ->whereBetween('created_at', [now()->subDays(7)->startOfDay(), now()->endOfDay()])
            ->selectRaw('DATE(created_at) as date, COUNT(*) as count')
            ->groupBy('date')
            ->get()
            ->keyBy('date');

        $platinumUsers = User::where('user_type', 'Platinum')
            ->where('is_admin', false)
            ->whereBetween('created_at', [now()->subDays(7)->startOfDay(), now()->endOfDay()])
            ->selectRaw('DATE(created_at) as date, COUNT(*) as count')
            ->groupBy('date')
            ->get()
            ->keyBy('date');

        $sponsoredUsers = User::where('user_type', 'Sponsored')
            ->where('is_admin', false)
            ->whereBetween('created_at', [now()->subDays(7)->startOfDay(), now()->endOfDay()])
            ->selectRaw('DATE(created_at) as date, COUNT(*) as count')
            ->groupBy('date')
            ->get()
            ->keyBy('date');

        $subCards = SubCard::where('is_active', true)
            ->whereBetween('created_at', [now()->subDays(7)->startOfDay(), now()->endOfDay()])
            ->selectRaw('DATE(created_at) as date, COUNT(*) as count')
            ->groupBy('date')
            ->get()
            ->keyBy('date');

        $freeUsersChartData = [];
        $basicUsersChartData = [];
        $goldUsersChartData = [];
        $platinumUsersChartData = [];
        $sponsoredUsersChartData = [];
        $subCardsChartData = [];

        for ($i = 6; $i >= 0; $i--) {
            $date = now()->subDays($i)->format('Y-m-d');

            $freeUsersChartData[] = $freeUsers->get($date)->count ?? 0;
            $basicUsersChartData[] = $basicUsers->get($date)->count ?? 0;
            $goldUsersChartData[] = $goldUsers->get($date)->count ?? 0;
            $platinumUsersChartData[] = $platinumUsers->get($date)->count ?? 0;
            $sponsoredUsersChartData[] = $sponsoredUsers->get($date)->count ?? 0;
            $subCardsChartData[] = $subCards->get($date)->count ?? 0;
        }

        return [
            Stat::make('Free', User::where('user_type', 'Free')->where('is_admin', false)->count())
                ->description('Free Card Holders')
                ->descriptionIcon('heroicon-m-arrow-up-right')
                ->color('info')
                ->chart($freeUsersChartData)
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                    'wire:click' => 'redirectFreeClients',
                ]),

            Stat::make($settings->term_basic, User::where('user_type', 'Basic')->where('is_admin', false)->count())
                ->description($settings->term_basic . ' Card Holders')
                ->descriptionIcon('heroicon-m-arrow-up-right')
                ->color('success')
                ->chart($basicUsersChartData)
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                    'wire:click' => 'redirectBasicClients',
                ]),

            Stat::make($settings->term_gold, User::where('user_type', 'Gold')->where('is_admin', false)->count())
                ->description($settings->term_gold . ' Card Holders')
                ->descriptionIcon('heroicon-m-arrow-up-right')
                ->color('warning')
                ->chart($goldUsersChartData)
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                    'wire:click' => 'redirectGoldClients',
                ]),

            Stat::make($settings->term_platinum, User::where('user_type', 'Platinum')->where('is_admin', false)->count())
                ->description($settings->term_platinum . ' Card Holders')
                ->descriptionIcon('heroicon-m-arrow-up-right')
                ->color('gray')
                ->chart($platinumUsersChartData)
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                    'wire:click' => 'redirectPlatinumClients',
                ]),

            Stat::make('Sponsored', User::where('user_type', 'Sponsored')->where('is_admin', false)->count())
                ->description('Sponsored Card Holders')
                ->descriptionIcon('heroicon-m-arrow-up-right')
                ->color('danger')
                ->chart($sponsoredUsersChartData)
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                    'wire:click' => 'redirectSponsoredClients',
                ]),

            Stat::make('SubCards', SubCard::where('is_active', true)->count())
                ->description('View SubCards')
                ->descriptionIcon('heroicon-m-arrow-up-right')
                ->color('success')
                ->chart($subCardsChartData)
                ->color('success')
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                    'wire:click' => 'redirectSubCardsClients',
                ]),
        ];
    }
}
