<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Social;
use Illuminate\Support\Facades\Auth;

class SocialController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('pages.add-social');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'link' => 'required|url|unique:socials,link',
            'type' => 'required|in:facebook,x,linkedin,instagram,tiktok,youtube'
        ]);

        //save user id
        $validated['user_id'] = Auth::user()->id;

        //save to database
        Social::create($validated);

        return redirect()->route('dashboard.social')->with('success', 'Social link successfully added!');
    }

    public function active(Request $request)
    {
        $validated = $request->validate([
            'button_id' => 'required|integer'
        ]);

        $social = Social::where('id', $validated['button_id'])
            ->where('user_id', Auth::user()->id)->first();

        if ($social) {
            //If true, change to false. If false, change to true
            $social['is_active'] = !$social['is_active'];
            $social->save();

            $socials = Social::where('user_id', Auth::user()->id)->get();

            if ($socials->isNotEmpty()) {
                return redirect()->route('dashboard.social', compact('socials'));
            }

            return redirect()->route('dashboard.social', ['socials' => 0]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(String $social)
    {
        //check if button exist and belongs to the user
        $check = Social::where('id', $social)->where('user_id', Auth::user()->id)->get();
        $socials = Social::where('user_id', Auth::user()->id)->get();

        // If exist
        if ($check->isNotEmpty()) {
            //Delete
            Social::where('id', $social)->where('user_id', Auth::user()->id)->delete();

            if ($socials->isNotEmpty()) {
                return redirect()->route('dashboard.social', compact('socials'))->with('success', 'Social Link Removed.');
            }

            return redirect()->route('dashboard.social', ['socials' => 0])->with('success', 'Social Link Removed.');
        } else {

            if ($socials->isNotEmpty()) {
                return redirect()->route('dashboard.social', compact('socials'))->with('error', 'Unauthorized action.');
            }

            return redirect()->route('dashboard.social', ['socials' => 0])->with('error', 'Unauthorized action.');
        }
    }
}
