<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class SubscriptionController
{

    public function portal(Request $request)
    {
        return $request->user()->redirectToBillingPortal(route('dashboard.subscription'));
    }

    public function resume(Request $request)
    {
        $request->user()->subscription()->resume();

        return back();
    }

    public function cancel(Request $request)
    {
        // $request->user()->subscription()->cancel();
        // $request->user()->subscription('default')->cancel();

        $subscription = $request->user()->subscription('default');

        if ($subscription && $subscription->valid()) {
            $subscription->cancel();
        }

        return back();
    }

    public function invoice(Request $request)
    {
        return $request->user()->downloadInvoice($request->invoice);
    }
}
