<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class CheckActiveUser
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();

        // Check if the user is authenticated and if the 'is_active' column is false
        if ($user && !$user->is_active) {
            Auth::logout(); // Log out the user
            return redirect()->route('login')->with('error', 'Your account is inactive.'); // Redirect with an error message
        }

        return $next($request);
    }
}
