<?php

namespace App\Http\Middleware;

use Closure;
use App\Settings\CardDefaultsSetting;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class CheckIfMaintenance
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */

    public function handle(Request $request, Closure $next): Response
    {
        $settings = app(CardDefaultsSetting::class);

        if ($settings->maintenance_mode == true) {
            Auth::logout(); // Log out the user
            session()->flash('error', 'Ongoing maintenance. Sorry for the inconvenience. Please try again later.');

            return redirect()->route('login');
        }
        return $next($request);
    }
}
