<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class CheckUserAffiliate
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        // $user = Auth::user();
        if (auth()->user() && !in_array(auth()->user()->user_type, ['Basic', 'Gold', 'Platinum', 'Influencer', 'Sponsored'])) {
            abort(403);
            // Auth::logout(); // Log out the user
            // return redirect()->route('login')->with('error', 'Your account is inactive.'); // Redirect with an error message
        }

        return $next($request);
    }
}
