<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class checkIfVerified
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // if not email verified, go to email verification page
        if (!$request->user()->hasVerifiedEmail() && $request->route()->getName() !== 'verification.notice') {
            return redirect()->route('verification.notice');
        }

        // if ($request->user()->user_type === null && $request->route()->getName() !== 'plan.index' && !$request->user()?->subscribed()) {
        //     return redirect()->route('plan.index');
        // }


        // if setup is incomplete
        if ($request->user()->user_type === null && $request->route()->getName() !== 'plan.index') {
            return redirect()->route('plan.index');
        }

        //if registered/or admin created go to dashboard
        // if ($request->user()->user_type != null && $request->route()->getName() !== 'dashboard.index') {
        //     return redirect()->route('dashboard.index');
        // }

        // if (
        //     $request->user()->hasVerifiedEmail() &&
        //     $request->user()->user_type != null &&
        //     $request->user()->job_title === null &&
        //     $request->route()->getName() !== 'dashboard.index'
        // ) {
        //     return redirect()->route('dashboard.index');
        // }

        // If setup complete but missing job title, redirect to dashboard setup page
        if (
            $request->user()->hasVerifiedEmail() &&
            $request->user()->user_type !== null &&
            $request->user()->job_title === null &&
            $request->route()->getName() === 'dashboard.index'
        ) {
            return redirect()->route('dashboard.index');
        }

        return $next($request);
    }
}
