<?php

namespace App\Listeners;

use App\Models\User;
use Laravel\Cashier\Cashier;
use Laravel\Cashier\Events\WebhookReceived;

class HandleSubscriptionEnded
{
    public function handle(WebhookReceived $event): void
    {
        $payload = $event->payload;

        $type = $payload['type'] ?? null;
        $subscription = $payload['data']['object'] ?? null;

        if (!in_array($type, ['customer.subscription.deleted', 'customer.subscription.updated'])) {
            return;
        }

        $user = $this->getUserByStripeId($subscription['customer'] ?? '');

        if (!$user) {
            return;
        }

        // Check if subscription is canceled or trial ended without payment
        $isCanceled = $type === 'customer.subscription.deleted';
        $isTrialEndedWithoutActiveStatus = $type === 'customer.subscription.updated'
            && $subscription['status'] !== 'active'
            && isset($subscription['trial_end'])
            && now()->timestamp >= $subscription['trial_end'];

        if ($isCanceled || $isTrialEndedWithoutActiveStatus) {
            if ($user->user_type !== 'Free') {
                $user->update(['user_type' => 'Free']);
            }
        }
    }

    protected function getUserByStripeId(string $stripe_id): ?User
    {
        return Cashier::findBillable($stripe_id);
    }
}
