<?php

namespace App\Livewire;

use Livewire\Component;

class ActionSheet extends Component
{
    public $user_type;
    public $subcards_count;

    public function mount()
    {
        if (auth()->user()) {
            $this->countSubcards();
            $this->user_type = auth()->user()->user_type;
        }
    }

    public function countSubcards()
    {
        $this->subcards_count = auth()->user()->subcards()
            ->select('id', 'username', 'job_title')
            ->count();
    }

    public function render()
    {
        return view('components.action-sheet');
    }
}
