<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\User;
use App\Models\SubCard;
use App\Models\Analytics;
use Carbon\Carbon;

class AdComponent extends Component
{
    public $ads;
    public $ad_id;
    public $condition;
    public $query;

    public $checkMain;
    public bool $mainCard = false;
    public $page_id;
    public $user;
    public $user_id;
    public $username;

    protected $listeners = ['adClicked'];

    public function adClicked($ad_id, $device, $location)
    {
        // dd($ad_id, $device, $location);
        if ($this->mainCard == true) {
            //main card
            $this->query = ['user_id' => $this->user_id, 'page_id' => NULL];
        } else {
            //subcard
            // $this->query = ['user_id' => $this->user_id, 'page_id' => $this->page_id];
            $this->query = ['page_id' => $this->page_id];
        }

        $existingClick = Analytics::where('ip_address', $location['ip'] ?? null)
            ->where($this->query)
            ->where('device_type', $device)
            ->where('ad_id', $ad_id)
            ->where('type', 'ad_click')
            ->whereDate('clicked_at', Carbon::today())
            ->first();

        if (!$existingClick) {

            Analytics::create(array_merge(
                [
                    'ad_id'       => $ad_id,
                    'device_type' => $device,
                    'ip_address'  => $location['ip'] ?? null,
                    'city'        => $location['city'] ?? null,
                    'region'      => $location['region'] ?? null,
                    'country'     => $location['country'] ?? null,
                    'clicked_at'  => now(),
                    'type'        => 'ad_click'
                ],
                $this->query
            ));
        }
    }

    public function mount($username)
    {
        //used to determine where to check if the username exist
        $this->checkMain = User::where('username', $username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();

            $this->condition = ['user_id' => $this->user_id, 'page_id' => NULL];
        } else {
            $this->mainCard = false;
            $this->page_id = SubCard::where('username', $username)
                ->pluck('id')
                ->first();

            $this->user_id = SubCard::where('username', $username)
                ->pluck('user_id')
                ->first();

            // $this->condition = ['user_id' => NULL, 'page_id' => $this->page_id];
            $this->condition = ['page_id' => $this->page_id];
        }
    }

    public function render()
    {
        return view('livewire.ad-component');
    }
}
