<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Button;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use Illuminate\Validation\ValidationException;

class AddCommunityLink extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $title, $link, $type;
    public $page_id; //subcard id, used in query

    public function saveCommunityLink()
    {
        try {
            $validated = $this->validate([
                'title' => 'required|string',
                'link' => 'required|url',
                'type' => 'required|in:fb_community,whatsapp_community,discord_community,telegram_community,skool_community',
            ]);

            $validated['user_id'] = auth()->user()->id;
            $validated['view'] = 'communities';

            $checkifactive = User::where('id', auth()->user()->id)
                ->where('active_card', true)->count();

            //if maincard is not active
            if ($checkifactive < 1) {
                $this->page_id = SubCard::where('user_id', auth()->user()->id)
                    ->where('active_card', true)
                    ->pluck('id')
                    ->first();
                $validated['page_id'] = $this->page_id;
            }

            $addCommunityLink = Button::create($validated);

            if ($addCommunityLink) {
                session()->flash('success', 'Community link successfully added!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }

            return $this->redirect('/dashboard/communities', navigate: true);
        } catch (ValidationException $e) {
            // stop spinner on validation errors
            $this->dispatch('set-submitting', ['value' => false]);
            throw $e;
        }
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->authorize('create', Button::class);
        return view('livewire.add-community-link')->title('Add Community Link | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
