<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\SubCard;
use App\Models\User;
use App\Models\Image;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Storage;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;

class AddImages extends Component
{
    use AuthorizesRequests;

    use WithFileUploads;
    public $images = [];
    public $tempImages = [];

    public $checkifactive, $images_count;
    public $to_upload_count = 10;

    // Site Settings
    public $site_url, $type = 'Squared';
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $page_id; //subcard id, used in query

    public function checkImages()
    {
        if (count($this->images) === 0) {
            $this->dispatch('no-images-left');
        } else {
            $this->dispatch('images-exist');
        }
    }

    public function removeTempImage($uniqueFileId)
    {
        // dd($uniqueFileId);
        foreach ($this->images as $index => $tempImage) {
            // dd($tempImage->getFilename(), $uniqueFileId);
            if ($tempImage->getFilename() === $uniqueFileId) {
                $tempFilePath = $tempImage->getRealPath();
                if (file_exists($tempFilePath)) {
                    unlink($tempFilePath);  // Delete the temporary file explicitly
                    unset($this->images[$index]);
                }
                break;
            }
        }
    }

    public function saveImages()
    {
        try {
            if (empty($this->images)) {
                session()->flash('info', 'Upload image(s) first before saving.');
                return $this->redirect('/dashboard/images', navigate: true);
            }

            //if maincard is not active
            if ($this->checkifactive < 1) {
                // save using subcard id
                foreach ($this->images as $tempImage) {
                    $imagePath = $tempImage->storePublicly('images', 'public');

                    Image::create([
                        'user_id' => NULL,
                        'type' => $this->type,
                        'page_id' => $this->page_id,
                        'image_path' => $imagePath,
                    ]);

                    $tempFilePath = $tempImage->getRealPath();

                    if (file_exists($tempFilePath)) {
                        unlink($tempFilePath);  // Delete the temporary file explicitly
                    }
                }
            } else {
                // save using main card
                foreach ($this->images as $tempImage) {
                    $imagePath = $tempImage->storePublicly('images', 'public');

                    Image::create([
                        'user_id' => auth()->user()->id,
                        'type' => $this->type,
                        'page_id' => NULL,
                        'image_path' => $imagePath,
                    ]);

                    $tempFilePath = $tempImage->getRealPath();

                    if (file_exists($tempFilePath)) {
                        unlink($tempFilePath);  // Delete the temporary file explicitly
                    }
                }
            }

            $this->images = [];
            session()->flash('success', 'Gallery successfully updated!');
            return $this->redirect('/dashboard/images', navigate: true);
        } catch (\Exception $e) {
            session()->flash('error', $e->getMessage());
            // session()->flash('error', 'The file must be an image (jpeg, png, jpg, heic, heif or webp).');
        }
    }

    public function mount()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive < 1) {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->images_count = Image::where('page_id', $this->page_id)->count();
        } else {
            $this->images_count = Image::where('user_id', auth()->user()->id)->whereNull('page_id')->count();
        }

        $this->to_upload_count = $this->to_upload_count - $this->images_count;
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->authorize('create', Image::class);
        return view('livewire.add-images')->title('Add Images | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
