<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\ProductCategory;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use Illuminate\Validation\ValidationException;

class AddProductCategory extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $title, $description;

    public $page_id; //subcard id, used in query

    public function saveCategory()
    {
        try {
            $validated = $this->validate([
                'title'       => 'required|string',
                'description' => 'nullable|string|max:500'
            ]);

            $user = auth()->user();
            $checkMainActive = User::where('id', $user->id)
                ->where('active_card', true)
                ->exists();

            if ($checkMainActive) {
                $validated['user_id'] = $user->id;
            } else {
                $subCardId = SubCard::where('user_id', $user->id)
                    ->where('active_card', true)
                    ->pluck('id')
                    ->first();

                if (!$subCardId) {
                    session()->flash('error', 'No active subcard found.');
                    return;
                }

                $validated['page_id'] = $subCardId;
            }

            $addProductCategory = ProductCategory::create($validated);

            if ($addProductCategory) {
                session()->flash('success', 'Category successfully added!');
            } else {
                session()->flash('error', 'Failed to add category.');
            }

            return $this->redirect('/dashboard/product-categories', navigate: true);
        } catch (ValidationException $e) {
            // stop spinner on validation errors
            $this->dispatch('set-submitting', ['value' => false]);
            throw $e;
        }
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        // $this->authorize('create', Product::class);
        return view('livewire.add-product-category')->title('Add Category | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
