<?php

namespace App\Livewire;

use App\Models\Product;
use Livewire\Component;
use App\Models\ProductMedia;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use App\Models\UserSettings;

class AddProductVideos extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public array $video_link = [''];
    public $page_id; //subcard id, used in query
    public $product_id;

    public $color_settings_profile_pic_border;
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    public $condition, $check_if_product_is_from_user;

    public $is_subscription;
    // public function addVideoLink()
    // {
    //     if (count($this->video_link) >= 3) {
    //         session()->flash('error', 'You can only add up to 3 video links.');
    //         return;
    //     }

    //     $this->video_link[] = '';
    // }

    public function addVideoLink()
    {
        // Count existing videos in the database
        $existingVideos = ProductMedia::where('product_id', $this->product_id)
            ->where('type', 'video')
            ->count();

        // Count current inputs in the form
        $currentNewVideos = count($this->video_link);

        // Enforce total limit (existing + new <= 3)
        if ($existingVideos + $currentNewVideos >= 3) {
            session()->flash('error', 'You can only have up to 3 video links per product.');
            return;
        }

        $this->video_link[] = '';
    }

    public function removeVideoLink($index)
    {
        unset($this->video_link[$index]);
        $this->video_link = array_values($this->video_link); // reindex
    }

    public function saveVideo()
    {

        // Filter out empty video links
        $videoLinks = array_filter($this->video_link, fn($link) => !empty($link));

        if (empty($videoLinks)) {
            session()->flash('error', 'Please add at least one video link.');
            return;
        }

        try {
            foreach ($videoLinks as $link) {
                ProductMedia::create([
                    'product_id' => $this->product_id,
                    'type' => 'video',
                    'path' => $link,
                ]);
            }

            session()->flash('success', 'Product videos successfully added!');

            if ($this->is_subscription) {
                return $this->redirect('/subscriptions/edit/' . $this->product_id, navigate: true);
            } else {
                return $this->redirect('/product/edit/' . $this->product_id, navigate: true);
            }
        } catch (\Throwable $e) {
            session()->flash('error', 'Something went wrong while saving the videos: ' . $e->getMessage());
            return redirect()->back()->withInput();
        }
    }


    public function mount($product_id)
    {
        $this->product_id = $product_id;

        $this->is_subscription = Product::where('id', $product_id)
            ->value('type') === 'subscription';

        $checkIfActive = User::where('id', auth()->id())
            ->where('active_card', true)->exists();

        if (!$checkIfActive) {
            $this->page_id = SubCard::where('user_id', auth()->id())
                ->where('active_card', true)
                ->value('id');
            $this->condition = ['page_id' => $this->page_id];
        } else {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        }

        $this->check_if_product_is_from_user = Product::where('id', $product_id)
            ->where($this->condition)->count();

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Text Color Settings
        $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';

        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';

        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
        $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
        $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
        $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;
        // $this->authorize('create', ProductMedia::class);

        return view('livewire.add-product-videos')->title('Add Product Videos | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
            'color_settings_profile_pic_border' => $this->color_settings_profile_pic_border,
            'color_settings_custom_button_text' => $this->color_settings_custom_button_text,
            'color_settings_custom_button' => $this->color_settings_custom_button,
            'app_name' => $this->app_name,
        ]);
    }
}
