<?php

namespace App\Livewire;

use App\Models\Sale;
use Livewire\Component;
use App\Models\SaleImage;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Livewire\Attributes\On;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use App\Settings\CardDefaultsSetting;
use Illuminate\Validation\ValidationException;

class AddSalesImage extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;

    public $page_id;

    public $product_name, $description, $stock = 1, $price, $image_path, $shop_online_link;
    public $is_active = true;
    public $shop_online_button = "Shop Online";
    public $sales_id, $image;

    #[On('salesImage')]
    public function setSalesImage($eventImageUrl)
    {
        $this->image = new TemporaryUploadedFile($eventImageUrl, config('filesystems.default'));
    }

    public function saveImage()
    {
        $validated = $this->validate([
            'image'                 => 'required|image|max:2048',
            'product_name'          => 'required|string|max:100',
            'stock'                 => 'required|numeric',
            'price'                 => 'required|numeric',
            'description'           => 'nullable|string|max:300',
            'shop_online_button'    => 'nullable|string',
            'shop_online_link'      => 'required|url',
            'is_active'             => 'required|boolean',
        ]);

        // Handle image upload
        if ($this->image instanceof TemporaryUploadedFile) {
            $validated['image_path'] = $this->image->storePublicly('sales', 'public');

            $tempFilePath = $this->image->getRealPath();
            if (file_exists($tempFilePath)) {
                unlink($tempFilePath);
            }
        }

        // $this->checkifactive = User::where('id', auth()->user()->id)
        //     ->where('active_card', true)->count();

        // if ($this->checkifactive < 1) {
        //     $this->page_id = SubCard::where('user_id', auth()->user()->id)
        //         ->where('active_card', true)
        //         ->pluck('id')
        //         ->first();

        //     $validated['page_id'] = $this->page_id;
        // } else {
        //     $validated['user_id'] = auth()->user()->id;
        // }

        $validated['sales_id'] = $this->sales_id;

        $addSalesPage = SaleImage::create($validated);

        if ($addSalesPage) {
            session()->flash('success', 'Image successfully added!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/sales/edit/' . $this->sales_id, navigate: true);
    }

    public function toggleActive()
    {
        $this->is_active = !$this->is_active;
    }

    public function mount(Sale $sales)
    {
        $this->sales_id = $sales->id;
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;

        $this->authorize('create', SaleImage::class);

        return view('livewire.add-sales-image')->title('Add Image | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
        ]);
    }
}
