<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Video;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use Livewire\Attributes\On;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use Illuminate\Validation\ValidationException;

class AddVideo extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $title, $video_type, $link, $button_title, $button_link, $video_thumbnail;

    public $page_id; //subcard id, used in query

    //  #[On('eventImage')]
    #[On('videoThumbnail')]
    // public function setEventImage($eventImageUrl)
    public function setVideoThumbnail($videoThumbnailUrl)
    {
        $this->video_thumbnail = new TemporaryUploadedFile($videoThumbnailUrl, config('filesystems.default'));
    }

    public function saveVideo()
    {

        try {
            $validated = $this->validate([
                'video_thumbnail'   => 'nullable|string',
                'title'             => 'required|string',
                'video_type'        => 'required|in:youtube,vimeo',
                'link'              => 'required|url',
                'button_title'      => 'nullable|string',
                'button_link'       => 'nullable|url',
            ]);

            $validated['user_id'] = auth()->user()->id;

            // if ($this->video_thumbnail) {
            if ($this->video_thumbnail instanceof TemporaryUploadedFile && $this->video_thumbnail->isValid()) {

                $validated['thumbnail'] =  $this->video_thumbnail->storePublicly('video_thumbnails', 'public');

                // Clean up temporary file
                $tempFilePath = $this->video_thumbnail->getRealPath();
                if (file_exists($tempFilePath)) {
                    unlink($tempFilePath);
                }
            }

            $checkifactive = User::where('id', auth()->user()->id)
                ->where('active_card', true)->count();

            //if maincard is not active
            if ($checkifactive < 1) {
                $this->page_id = SubCard::where('user_id', auth()->user()->id)
                    ->where('active_card', true)
                    ->pluck('id')
                    ->first();
                $validated['page_id'] = $this->page_id;
            }

            $addVideo = Video::create($validated);

            if ($addVideo) {
                session()->flash('success', 'Video successfully added!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }
        } catch (ValidationException $e) {
            // stop spinner on validation errors
            $this->dispatch('set-submitting', ['value' => false]);
            throw $e;
        }

        return $this->redirect('/dashboard/video', navigate: true);
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->authorize('create', Video::class);
        return view('pages.add-video')->title('Add Video | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
