<?php

namespace App\Livewire;

use App\Models\Analytics;
use App\Models\SubCard;
use App\Models\User;
use App\Settings\CardDefaultsSetting;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Carbon\Carbon;
use Livewire\Component;

class AnalyticsPage extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $user;
    public $social_count;
    public $button_count;
    public $product_count;
    public $video_count;

    public $button_analytics_by_month;
    public $links_view_count_7_days;

    public $card_view_analytics_by_month;
    public $card_view_analytics_7_days;

    public $socials_view_analytics_by_month;
    public $socials_view_analytics_7_days;

    public $ads_view_analytics_by_month;
    public $ads_view_analytics_7_days;

    public $months;
    public $days;

    // public $maincard_active; //used to determine which card is active
    public $page_id; //subcard id, used in query
    public $query;

    public function showAnalytics()
    {
        $year = Carbon::now()->year;
        $cardViewCounts = [];
        $linkMonthlyCounts = [];
        $socialMonthlyCounts = [];
        $adMonthlyCounts = [];

        $startOfWeek = Carbon::now()->startOfWeek(); // Monday
        $endOfWeek = Carbon::now()->endOfWeek();     // Sunday
        $currentDate = $startOfWeek->copy();

        $cardViewCounts_7days = [];
        $linksViewCounts_7days = [];
        $socialsViewCounts_7days = [];
        $adsViewCounts_7days = [];

        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();
        // if active, get the datas and set to form
        if ($checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic', 'user_type']);
            $this->query = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.user_id', auth()->user()->id)
                ->where('subcards.active_card', true)
                ->first([
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'users.firstname',
                    'users.lastname',
                    'users.user_type',
                ]);

            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            // $this->query = ['user_id' => auth()->user()->id, 'page_id' => $this->page_id];
            $this->query = ['page_id' => $this->page_id];
        }

        for ($month = 1; $month <= 12; $month++) {
            //button_click
            $count = Analytics::where($this->query)
                ->where('type', 'button_click')
                ->whereMonth('clicked_at', $month)
                ->whereYear('clicked_at', $year)
                ->count();

            //social_click
            $social_click_count = Analytics::where($this->query)
                ->where('type', 'social_click')
                ->whereMonth('clicked_at', $month)
                ->whereYear('clicked_at', $year)
                ->count();

            //ad_click
            $ad_click_count = Analytics::where($this->query)
                ->where('type', 'ad_click')
                ->whereMonth('clicked_at', $month)
                ->whereYear('clicked_at', $year)
                ->count();

            //card_view
            $card_view_count = Analytics::where($this->query)
                ->where('type', 'card_view')
                ->whereMonth('viewed_at', $month)
                ->whereYear('viewed_at', $year)
                ->count();

            // Use 3-letter month name as key (Jan, Feb, etc.)
            $linkMonthlyCounts[Carbon::create()->month($month)->format('M')] = $count;
            $cardViewCounts[Carbon::create()->month($month)->format('M')] = $card_view_count;
            $socialMonthlyCounts[Carbon::create()->month($month)->format('M')] = $social_click_count;
            $adMonthlyCounts[Carbon::create()->month($month)->format('M')] = $ad_click_count;
            $this->months = array_keys($linkMonthlyCounts);
        }

        while ($currentDate->lte($endOfWeek)) {
            //button_click
            $count = Analytics::where($this->query)
                ->where('type', 'button_click')
                ->whereDate('clicked_at', $currentDate)
                ->count();

            //social_click
            $social_click_count = Analytics::where($this->query)
                ->where('type', 'social_click')
                ->whereDate('clicked_at', $currentDate)
                ->count();

            //ad_click
            $ad_click_count = Analytics::where($this->query)
                ->where('type', 'ad_click')
                ->whereDate('clicked_at', $currentDate)
                ->count();

            //card_view
            $card_view_count = Analytics::where($this->query)
                ->where('type', 'card_view')
                ->whereDate('viewed_at', $currentDate)
                ->count();

            $cardViewCounts_7days[$currentDate->format('D')] = $card_view_count;
            $linksViewCounts_7days[$currentDate->format('D')] = $count;
            $socialsViewCounts_7days[$currentDate->format('D')] = $social_click_count;
            $adsViewCounts_7days[$currentDate->format('D')] = $ad_click_count;

            $currentDate->addDay();
        }

        $this->days = array_keys($cardViewCounts_7days);

        //card
        $this->card_view_analytics_7_days = $cardViewCounts_7days;
        $this->links_view_count_7_days = $linksViewCounts_7days;

        //button
        $this->button_analytics_by_month = $linkMonthlyCounts;
        $this->card_view_analytics_by_month = $cardViewCounts;

        //social
        $this->socials_view_analytics_by_month = $socialMonthlyCounts;
        $this->socials_view_analytics_7_days = $socialsViewCounts_7days;

        //ad
        $this->ads_view_analytics_by_month = $adMonthlyCounts;
        $this->ads_view_analytics_7_days = $adsViewCounts_7days;
    }

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->showAnalytics();
    }

    public function render()
    {
        // dd($this->socials_view_analytics_by_month, $this->socials_view_analytics_7_days);
        $this->authorize('view', Analytics::class);
        return view('livewire.analytics-page', [
            'user' => $this->user,
        ])->title('Analytics | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
