<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Button;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use App\Helpers\SavingLinkHelpers;
use Illuminate\Validation\ValidationException;

class ButtonActionSheet extends Component
{
    public $title;
    public $link;
    public $type;
    public $display_as = 'button';

    public $page_id; //subcard id, used in query
    public $routeName;

    public function save($type)
    {
        try {
            $this->type = $type;

            $validated = $this->validate([
                'title' => 'required|string|max:100',
                'display_as' => 'required|in:button,icon',
                'link' => 'required|string',
                'type' => 'required|in:link,podcast,community,email,phone,sms,whatsapp,zalo,wechat,amazon_shop,telegram,zoom,cashapp,chime,square,payment_other,paypal_link,paypal_email,apple_pay,venmo,credit,zelle,google_map,apple_map,waze',
            ]);

            $validated['user_id'] = Auth::user()->id;

            if (auth()->user()->user_type == 'Free') {
                if ($this->routeName === 'button.index') {
                    $validated['display_as'] = 'button';
                }

                if ($this->routeName === 'contacts.add') {
                    $validated['display_as'] = 'icon';
                }
            }

            //after validating, assign "view" based on "type"
            if ($validated['display_as'] === 'icon') {
                //check the link type to determine how to display it on the card
                if (in_array($this->type, ['cashapp', 'chime', 'square', 'payment_other', 'paypal_link', 'paypal_email', 'apple_pay', 'venmo', 'credit', 'zelle'])) {
                    $validated['view'] = 'payments';
                } else if (in_array($this->type, ['email', 'phone', 'sms', 'zalo', 'wechat', 'amazon_shop', 'whatsapp', 'telegram', 'zoom', 'community'])) {
                    $validated['view'] = 'contacts';
                }
            }

            if ($validated['display_as'] === 'button' && !in_array($this->type, ['google_map', 'apple_map', 'waze'])) {
                //save the view as 'links'
                $validated['view'] = 'links';
            }

            if (in_array($this->type, ['google_map', 'apple_map', 'waze'])) {
                $validated['view'] = 'directions';
            }

            $checkifactive = User::where('id', auth()->user()->id)
                ->where('active_card', true)->count();

            //if maincard is not active
            if ($checkifactive < 1) {
                $this->page_id = SubCard::where('user_id', auth()->user()->id)
                    ->where('active_card', true)
                    ->pluck('id')
                    ->first();
                $validated['page_id'] = $this->page_id;
            }

            // run validations
            try {
                $saveButton = Button::create($validated);
            } catch (\Exception $e) {
                session()->flash('error', $e->getMessage());
                return redirect()->back();
            }

            if ($saveButton) {
                if ($validated['display_as'] === 'icon') {
                    if ($validated['view'] == 'payments') {
                        session()->flash('success', 'Payment link successfully added!');
                        return $this->redirect('/dashboard/payments', navigate: true);
                    } else if ($validated['view'] == 'contacts') {
                        session()->flash('success', 'Contact point successfully added!');
                        return $this->redirect('/dashboard/contacts', navigate: true);
                    }
                } else {
                    if ($validated['view'] == 'links') {
                        session()->flash('success', 'Link successfully added!');
                        return $this->redirect('/dashboard/button', navigate: true);
                    } else if ($validated['view'] == 'directions') {
                        session()->flash('success', 'Direction link successfully added!');
                        return $this->redirect('/dashboard/directions', navigate: true);
                    }
                }
            } else {
                session()->flash('error', 'Unauthorized action.');
                return $this->redirect('/dashboard/profile', navigate: true);
            }
        } catch (ValidationException $e) {
            // stop spinner on validation errors
            $this->dispatch('set-submitting', ['value' => false]);
            throw $e;
        }
    }

    public function render()
    {
        return view('components.button-action-sheet');
    }
}
