<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Analytics;
use App\Models\User;
use App\Models\SubCard;
use Carbon\Carbon;
use App\Models\UserSettings;

class ButtonComponent extends Component
{
    public $button_id;
    public $button_type;
    public $user_id;
    public $username;
    public $link;
    public $title;

    public bool $mainCard = false;
    public $page_id;
    public $user;

    public $checkMain;
    public $checkSub;
    protected $listeners = ['buttonClicked'];

    public $color_settings_custom_button;
    public $color_settings_custom_button_text;

    public $condition;
    public $query;

    //style
    public $button_style;

    public function buttonClicked($button_id, $device, $location)
    {
        // dd($this->user_id, $this->page_id, $button_id, $device, $location['ip'], $location['city'], $location['region'], $location['country']);
        if ($this->mainCard == true) {
            //main card
            $this->query = ['user_id' => $this->user_id, 'page_id' => NULL];
        } else {
            //subcard
            // $this->query = ['user_id' => $this->user_id, 'page_id' => $this->page_id];
            $this->query = ['page_id' => $this->page_id];
        }

        $existingClick = Analytics::where('ip_address', $location['ip'] ?? null)
            ->where($this->query)
            ->where('device_type', $device)
            ->where('button_id', $button_id)
            ->where('type', 'button_click')
            ->whereDate('clicked_at', Carbon::today())
            ->first();

        if (!$existingClick) {

            Analytics::create(array_merge(
                [
                    'button_id'   => $button_id,
                    'device_type' => $device,
                    'ip_address'  => $location['ip'] ?? null,
                    'city'        => $location['city'] ?? null,
                    'region'      => $location['region'] ?? null,
                    'country'     => $location['country'] ?? null,
                    'clicked_at'   => now(),
                    'type'        => 'button_click'
                ],
                $this->query
            ));
        }
    }

    public function mount($username)
    {
        //used to determine where to check if the username exist
        $this->checkMain = User::where('username', $username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();

            $this->condition = ['user_id' => $this->user_id, 'page_id' => NULL];
        } else {
            $this->mainCard = false;
            $this->page_id = SubCard::where('username', $username)
                ->pluck('id')
                ->first();

            $this->user_id = SubCard::where('username', $username)
                ->pluck('user_id')
                ->first();

            // $this->condition = ['user_id' => $this->user_id, 'page_id' => $this->page_id];
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->button_style = UserSettings::where('setting_key', 'button_style')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
        //style
        $this->button_style = $this->button_style ?: 'rounded';
    }

    public function render()
    {
        return view('livewire.button-component');
    }
}
