<?php

namespace App\Livewire;

use App\Models\Ad;
use Livewire\Component;
use App\Models\User;
use App\Models\UserSettings;
use App\Models\SubCard;
use App\Models\Social;
use App\Models\Button;
use App\Models\Direction;
use App\Models\Image;
use App\Models\Product;
use App\Models\Referral;
use App\Models\Service;
use App\Models\Event;
use App\Models\Member;
use App\Models\Replay;
use App\Models\Review;
use App\Models\Sale;
use App\Models\Sponsor;
use App\Models\TrustedNetwork;
use App\Models\Video;
use App\Settings\CardDefaultsSetting;
use Illuminate\Support\Str;

class Card extends Component
{
    // Site Settings
    public $site_url;
    public $app_name;
    public $site_name;
    public $thumbnail;
    public $affiliate_functionality;

    public $default_ads_enabled;
    public $ad_items;
    public $default_ads;
    public $combined_ads;

    public $ad_banner_w;
    public $ad_banner_h;

    public $card_title;
    public $page_title;

    public $username;
    public $socials;
    public $buttons, $reviews, $replays, $trusted_network;
    public $contacts;
    public $communities;
    public $payments;
    public $directions;
    public $products;
    public $sales;
    public $team;
    public $events;
    public $services;
    public $videos;
    public $user;
    public $video_count;
    public $images_count;
    public $gallery_main;
    public $connect_main;
    public $connect_icon;
    // public $feedback_form;

    // Click here button
    public ?string $click_videos;
    public ?string $click_videos_enabled;
    public ?string $click_videos_link;

    public ?string $click_gallery;
    public ?string $click_gallery_enabled;
    public ?string $click_gallery_link;

    //Ads
    public $ads_top, $ads_bottom;

    // To display as SEO
    public $fullname;
    public $favicon;
    public $bio;

    public $customFooter = false;
    public $getAds = false;

    //footer by user
    public ?bool $footer_enabled;

    public ?bool $getacard_enabled;

    public ?string $footer_text;
    public ?string $footer_link;

    //check if card is active
    public $is_active;

    //check if card is searchable
    public $searchable;

    //check if country display is enabled
    public $display_country;
    public $payment_text;

    //short bio
    public $short_bio_enabled;

    //username
    public $username_enabled;

    //exchange contact
    // public $exchange_contact_enabled;

    //profile layout
    public $profile_layout;

    //footer by user
    public ?string $default_footer_text;
    public ?string $default_footer_link;

    //shop button text
    public ?string $shop_text;

    public ?string $services_text;

    //colors
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_link;
    public $color_settings_profile_pic_border;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    // custom text
    public $follow_text;
    public $contact_text;
    public $bio_text;

    //style
    public $button_style;

    //for VCF
    public $firstname, $lastname, $email, $phone, $gender, $customLinks, $job_title, $company, $company_website, $vbc, $profile_pic, $cover_pic, $user_type, $sponsor_id;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;
    public $condition;
    public $query;

    public $referrer_username, $referral, $referrer_id;

    public $sponsor_username, $sponsor_user_id;

    public function displayCard($username)
    {
        // get user creds
        $this->username = $username;

        // If user exist
        if ($this->user) {
            // main card

            if ($this->mainCard == true) {
                $this->condition = ['user_id' => $this->user->id, 'page_id' => NULL];
                $this->query = ['user_id' => $this->user->id, 'page_id' => NULL];
            } else {
                // $this->condition = ['user_id' => $this->user->id, 'page_id' => $this->page_id];
                $this->condition = ['page_id' => $this->page_id];
                $this->query = ['page_id' => $this->page_id];
            }

            $this->video_count = Video::where('is_active', true)
                ->where($this->condition)
                ->count();

            $this->images_count = Image::where('is_active', true)
                ->where($this->condition)
                ->count();

            //Settings: Check if card is searchable
            $this->searchable = UserSettings::where('setting_key', 'searchable')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            //Settings: Footer set by the user
            $this->footer_text = UserSettings::where('setting_key', 'footer_text')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            $this->footer_link = UserSettings::where('setting_key', 'footer_link')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            //Settings: Shop button text set by the user
            $this->shop_text = UserSettings::where('setting_key', 'shop_text')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            $this->services_text = UserSettings::where('setting_key', 'services_text')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            // Footer enabled
            $this->footer_enabled = UserSettings::where('setting_key', 'footer_enabled')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            $this->getacard_enabled = UserSettings::where('setting_key', 'getacard_enabled')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            // Country enabled
            $this->display_country = UserSettings::where('setting_key', 'display_country')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            $this->payment_text = UserSettings::where('setting_key', 'payment_text')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            //if user exist, get socials
            $this->socials = Social::where('is_active', true)
                ->where($this->condition)
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get videos
            if ($this->user->user_type == 'Basic') {
                $this->videos = Video::where('is_active', true)
                    ->where($this->condition)
                    ->limit(1)
                    ->orderBy('order', 'asc')
                    ->get();
            } else {
                $this->videos = Video::where('is_active', true)
                    ->where($this->condition)
                    ->orderBy('order', 'asc')
                    ->get();
            }

            //if user exist, get products
            $this->products = Product::where('is_active', true)
                ->where($this->condition)
                ->orderBy('order', 'asc')
                ->get();

            $this->sales = Sale::where('is_active', true)
                ->where($this->condition)
                ->orderBy('order', 'asc')
                ->get();

            $this->team = Button::where($this->condition)
                ->where('type', 'team')
                // ->orderBy('order', 'asc')
                ->get();

            //if user exist, get events
            $this->events = Event::where('is_active', true)
                ->where($this->condition)
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get services
            $this->services = Service::where('is_active', true)
                ->where($this->condition)
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get buttons
            $this->buttons = Button::where('is_active', true)
                ->where($this->condition)
                ->where('view', 'links')
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get contact points
            $this->reviews = Review::where($this->condition)
                ->where('is_active', true)
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get contact points
            $this->replays = Replay::where($this->condition)
                ->where('is_active', true)
                ->orderBy('order', 'asc')
                ->get();

            $this->trusted_network = TrustedNetwork::where($this->condition)
                // ->where('is_active', true)
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get contact points
            $this->contacts = Button::where('is_active', true)
                ->where($this->condition)
                ->where('view', 'contacts')
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get contact points
            $this->communities = Button::where('is_active', true)
                ->where($this->condition)
                ->where('view', 'communities')
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get payment links
            $this->payments = Button::where('is_active', true)
                ->where($this->condition)
                ->where('view', 'payments')
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get direction links
            $this->directions = Direction::where('is_active', true)
                ->where($this->condition)
                ->orderBy('order', 'asc')
                ->get();

            // Card title
            $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Page title
            $this->page_title = UserSettings::where('setting_key', 'custom_page_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //Gallery Main
            $this->gallery_main = UserSettings::where('setting_key', 'gallery_main')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            // Lets Connect Main
            $this->connect_main = UserSettings::where('setting_key', 'connect_main')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            //Let's Connect Icon
            $this->connect_icon = UserSettings::where('setting_key', 'connect_icon')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            // Feedback
            // $this->feedback_form = UserSettings::where('setting_key', 'feedback_form')
            //     ->where($this->query)
            //     ->pluck('setting_value')
            //     ->first();

            // Click here Videos
            $this->click_videos = UserSettings::where('setting_key', 'click_videos')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            $this->default_ads = UserSettings::where('setting_key', 'like', 'ads.%')
                ->where($this->query)
                ->pluck('setting_value', 'setting_key')
                ->toArray();

            $this->combined_ads = [];

            if (!in_array($this->user_type, ['Gold', 'Platinum'])) {
                foreach ($this->ad_items as $index => $item) {
                    // match user link key: ads.{index}.user_link
                    $settingKey = "ads.$index.user_link";

                    // Ensure id exists (fallback to index if not present)
                    $adId = $item['id'] ?? $index;

                    // merge user link (null if none) and convert to array
                    $this->combined_ads[$index] = array_merge($item, [
                        'id' => $adId,
                        'link' => $this->default_ads[$settingKey] ?? null,
                    ]);
                }

                // Convert Eloquent collections to arrays
                $this->ads_top = collect($this->ads_top)->map(fn($ad) => $ad->toArray())->toArray();
                $this->ads_bottom = collect($this->ads_bottom)->map(fn($ad) => $ad->toArray())->toArray();

                // Merge combined_ads based on position
                foreach ($this->combined_ads as $ad) {
                    $position = $ad['position'] ?? 'top'; // fallback to top

                    if ($ad['is_active']) {
                        if ($position === 'top') {
                            $this->ads_top[] = $ad;
                        } else {
                            $this->ads_bottom[] = $ad;
                        }
                    }
                }
            }

            $this->click_videos_enabled = UserSettings::where('setting_key', 'click_videos_enabled')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            $this->click_videos_link = UserSettings::where('setting_key', 'click_videos_link')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            // Click here Gallery
            $this->click_gallery = UserSettings::where('setting_key', 'click_gallery')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            $this->click_gallery_enabled = UserSettings::where('setting_key', 'click_gallery_enabled')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            $this->click_gallery_link = UserSettings::where('setting_key', 'click_gallery_link')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            // Short Bio enabled
            $this->short_bio_enabled = UserSettings::where('setting_key', 'display_short_bio')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            //username
            $this->username_enabled = UserSettings::where('setting_key', 'display_username')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            //exchange contact
            // $this->exchange_contact_enabled = UserSettings::where('setting_key', 'exchange_contact_enabled')
            //     ->where($this->query)
            //     ->pluck('setting_value')
            //     ->first();

            //profile layout
            $this->profile_layout = UserSettings::where('setting_key', 'profile_layout')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //colors
            $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_link = UserSettings::where('setting_key', 'color_settings_link')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Background Color Settings
            $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Text Color Settings
            $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->button_style = UserSettings::where('setting_key', 'button_style')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Follow text
            $this->follow_text = UserSettings::where('setting_key', 'follow_text')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            // Bio text
            $this->bio_text = UserSettings::where('setting_key', 'bio_text')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            // Contact text
            $this->contact_text = UserSettings::where('setting_key', 'contact_text')
                ->where($this->query)
                ->pluck('setting_value')
                ->first();

            if ($this->user->thumbnail) {
                $this->favicon = $this->user->thumbnail;
            } else {
                $this->favicon = $this->user->profile_pic;
            }

            $this->bio = $this->user->bio;
            // $this->feedback_form = $this->feedback_form ?? false;

            // Click here videos
            $this->click_videos = $this->click_videos ?: 'Click here';
            $this->click_videos_enabled = $this->click_videos_enabled ?? false;
            $this->click_videos_link = $this->click_videos_link ?: '';

            // Click here gallery
            $this->click_gallery = $this->click_gallery ?: 'Click here';
            $this->click_gallery_enabled = $this->click_gallery_enabled ?? false;
            $this->click_gallery_link = $this->click_gallery_link ?: '';
            $this->payment_text = $this->payment_text ?: 'Payment Links';

            // Set the fullanme
            $this->fullname = $this->firstname . ' ' . $this->lastname;
            //for VCF
            // $this->firstname = $this->user->firstname;
            // $this->lastname = $this->user->lastname;
            $this->email = $this->user->email;
            $this->job_title = $this->user->job_title;
            $this->phone = $this->user->phone;
            $this->gender = $this->user->gender;
            // $this->vbc = $this->site_url . 'card/' . $this->user->username;
            $this->vbc = $this->site_url . $this->user->username;
            $this->company = $this->user->company;

            //used only to determine the footer text and link
            $this->user_type = $this->user->user_type;

            //sponsor id
            $this->sponsor_id = $this->user->sponsor_id;

            // $this->profile_pic = str_replace('profile_pic/', '', $this->favicon);
            $this->company_website = $this->user->company_website;

            $this->is_active = $this->user->is_active;

            $this->searchable = $this->searchable ?? true;

            $this->follow_text = $this->follow_text ?: 'Follow me';
            $this->contact_text = $this->contact_text ?: 'Contact me';
            $this->bio_text = $this->bio_text ?: 'My Bio';
            $this->shop_text = $this->shop_text ?: 'Shop';
            $this->services_text = $this->services_text ?: 'Services';

            if ($this->footer_text && $this->footer_link) {
                $this->customFooter = true;
            }

            $this->footer_enabled = $this->footer_enabled ?? true;

            $this->getacard_enabled = $this->getacard_enabled ?? false;

            $this->display_country = $this->display_country ?? true;

            $this->gallery_main = $this->gallery_main ?? true;

            $this->connect_main = $this->connect_main ?? true;

            $this->connect_icon = $this->connect_icon ?? true;

            // if NULL, set to TRUE
            $this->short_bio_enabled = $this->short_bio_enabled ?? true;

            // if NULL, set to TRUE
            $this->username_enabled = $this->username_enabled ?? true;

            // if NULL, set to TRUE
            // $this->exchange_contact_enabled = $this->exchange_contact_enabled ?? true;

            $this->profile_layout = $this->profile_layout ?? 'default';

            if ($this->socials->isEmpty()) {
                $this->socials = 0;
            }

            if ($this->videos->isEmpty()) {
                $this->videos = 0;
            }

            if ($this->products->isEmpty()) {
                $this->products = 0;
            }

            if ($this->payments->isEmpty()) {
                $this->payments = 0;
            }

            if ($this->sales->isEmpty()) {
                $this->sales = 0;
            }

            if ($this->team->isEmpty()) {
                $this->team = 0;
            }

            // dd($this->team);

            if ($this->services->isEmpty()) {
                $this->services = 0;
            }

            if ($this->buttons->isEmpty()) {
                $this->buttons = 0;
            }

            if ($this->reviews->isEmpty()) {
                $this->reviews = 0;
            }

            if ($this->replays->isEmpty()) {
                $this->replays = 0;
            }

            if ($this->trusted_network->isEmpty()) {
                $this->trusted_network = 0;
            }

            if ($this->contacts->isEmpty()) {
                $this->contacts = 0;
            }

            if ($this->communities->isEmpty()) {
                $this->communities = 0;
            }

            if ($this->directions->isEmpty()) {
                $this->directions = 0;
            }

            if (!$this->page_title) {
                $this->page_title = $this->card_title;
            }

            if (!$this->card_title) {
                $this->card_title = $this->fullname;
            }

            if (!$this->video_count) {
                $this->video_count = 0;
            }

            if (!$this->events) {
                $this->events = 0;
            }

            //colors
            // if no value, set default colors
            $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
            $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
            $this->color_settings_link = $this->color_settings_link ?: '#ca8a04';
            $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
            $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
            $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
            $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
            $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';

            //style
            $this->button_style = $this->button_style ?: 'rounded';
        } else {
            $this->user = 0;
            $this->card_title = "Not found";
            $this->page_title = "Not found";
            $this->fullname = "Not found";
        }
    }

    public function __construct()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->app_name = $default->app_name;
        $this->default_footer_text = $default->footer_text;
        $this->default_footer_link = $default->footer_link;
        $this->thumbnail = $default->thumbnail;
        $this->ad_banner_w = $default->ad_banner_w;
        $this->ad_banner_h = $default->ad_banner_h;
        $this->affiliate_functionality = $default->affiliate_functionality;

        $this->default_ads_enabled = $default->default_ads_enabled;
        $this->ad_items = $default->ad_items;
    }

    public function mount($username)
    {
        $this->username = $username;

        $this->checkMain = User::where('username', $username)->count();
        $this->checkSub = SubCard::where('username', $username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->getAds = true;
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('username', $username)
                ->where('is_active', true)
                ->pluck('id')
                ->first();
            $this->mainCard = false;
            $this->getAds = true;
        }

        if ($this->mainCard == true) {
            $this->user = User::where('username', $this->username)->where('is_active', true)->first([
                'id',
                'email',
                'phone',
                'profile_pic',
                'cover_pic',
                'thumbnail',
                'username',
                'firstname',
                'lastname',
                'job_title',
                'company',
                'company_website',
                'bio',
                'bio_long',
                'language',
                'address',
                'country',
                'state',
                'user_type',
                'is_active',
                'sponsor_id'
            ]);

            if ($this->user) {
                $this->firstname = $this->user->firstname;
                $this->lastname = $this->user->lastname;
                $this->user_type = $this->user->user_type;
                $this->sponsor_id = $this->user->sponsor_id;
                $this->is_active = $this->user->is_active;
            } else {
                $this->user = 0;
                $this->card_title = "Not found";
                $this->page_title = "Not found";
                $this->fullname = "Not found";
                return;
            }

            $this->condition = ['user_id' => $this->user->id, 'page_id' => NULL];

            if ($this->user->user_type == 'Sponsored') {
                $this->sponsor_user_id = Sponsor::where('id', $this->sponsor_id)->where('is_active', true)->pluck('user_id')->first();
                $this->sponsor_username = User::where('id', $this->sponsor_user_id)->pluck('username')->first();
                if (!$this->sponsor_username) {
                    $this->sponsor_username = $this->username;
                }
            }
        }

        if ($this->checkSub > 0) {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.username', $this->username)
                ->first([
                    'subcards.id',
                    'subcards.user_id',
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.bio_long',
                    'subcards.profile_pic',
                    'subcards.cover_pic',
                    'subcards.thumbnail',
                    'subcards.firstname as subcard_firstname',
                    'subcards.lastname as subcard_lastname',
                    'users.firstname as user_firstname',
                    'users.lastname as user_lastname',
                    'users.address',
                    'users.country',
                    'users.state',
                    'users.user_type',
                    'users.id',
                    'subcards.email',
                    'subcards.phone',
                    'subcards.is_active'
                ]);

            if (!$this->user) {
                $this->user = 0;
                $this->card_title = "Not found";
                $this->page_title = "Not found";
                $this->fullname = "Not found";
                return;
            }

            $this->user_type = $this->user->user_type;
            $this->is_active = $this->user->is_active;

            // Handle fallback name if subcard firstname/lastname is missing
            $this->firstname = $this->user->subcard_firstname ?: $this->user->user_firstname;
            $this->lastname = $this->user->subcard_lastname ?: $this->user->user_lastname;

            $this->condition = ['page_id' => $this->page_id];
        }

        if ($this->user) {
            $this->referral = Referral::where('referred_id', $this->user->id)
                ->first();

            if ($this->referral) {
                if ($this->referral->referrer_id_main) {
                    // $this->referrer_username = User::where('id', $this->referral->referrer_id_main)->pluck('username')->first();
                    $referrer = User::where('id', $this->referral->referrer_id_main)->first();
                    $this->referrer_username = $referrer->username;
                    $this->referrer_id = $referrer->id;
                    $ad_query = ['user_id' => $this->referrer_id, 'page_id' => NULL];
                    // dd($this->referrer_username, $this->referrer_id);
                } else {
                    $referrer = SubCard::where('id', $this->referral->referrer_id_sub)->first();
                    $this->referrer_username = $referrer->username;
                    $this->referrer_id = $referrer->id;
                    // dd($this->referrer_username, $this->referrer_id);
                    $ad_query =  ['page_id' => $this->referrer_id];
                }
            }

            if ($this->getAds && $this->is_active) {
                if ($this->user_type == 'Free' && !$this->referral) {
                    // ads for free cards
                    $this->ads_top = Ad::where('is_active', true)
                        ->where('position', 'top')
                        ->where('is_admin', true)
                        ->where('display_in', 'Free')
                        ->ordered()
                        ->get();

                    $this->ads_bottom = Ad::where('is_active', true)
                        ->where('position', 'bottom')
                        ->where('is_admin', true)
                        ->where('display_in', 'Free')
                        ->ordered()
                        ->get();
                } elseif ($this->user_type == 'Free' && $this->referral) {

                    $this->ads_top = Ad::where('is_active', true)
                        ->where($ad_query)
                        ->where('position', 'top')
                        ->where('is_admin', false)
                        ->ordered()
                        ->get();

                    $this->ads_bottom = Ad::where('is_active', true)
                        ->where('position', 'bottom')
                        ->where($ad_query)
                        ->where('is_admin', false)
                        ->ordered()
                        ->get();

                    // dd($ad_query, $this->ads_top);
                }

                // Basic card who own ads
                else if ($this->user_type == "Basic") {
                    // else if ($this->user_type == "Basic" && !$referred_id) {
                    $this->ads_top = Ad::where('is_active', true)
                        ->where('is_admin', false)
                        ->where($this->condition)
                        ->where('position', 'top')
                        ->ordered()->get();

                    $this->ads_bottom = Ad::where('is_active', true)
                        ->where('is_admin', false)
                        ->where($this->condition)
                        ->where('position', 'bottom')
                        ->ordered()->get();
                }
                // Basic card who own ads
                // else if ($this->user_type == "Basic" && !$referred_id) {
                //     $this->ads_top = Ad::where('is_active', true)->where('is_admin', false)
                //         ->where('user_id', $this->user->id)
                //         ->where('page_id', NULL)
                //         ->where('position', 'top')
                //         ->ordered()->get();

                //     $this->ads_bottom = Ad::where('is_active', true)->where('is_admin', false)
                //         ->where('user_id', $this->user->id)
                //         ->where('page_id', NULL)
                //         ->where('position', 'bottom')
                //         ->ordered()->get();
                // } else if ($this->user_type == "Basic" && $referred_id) {
                //     $this->ads_top = Ad::where('is_active', true)->where('is_admin', false)
                //         ->where('user_id', $referral->referrer_id_main)
                //         ->where('page_id', NULL)
                //         ->where('position', 'top')
                //         ->ordered()->get();

                //     $this->ads_bottom = Ad::where('is_active', true)->where('is_admin', false)
                //         ->where('user_id', $referral->referrer_id_main)
                //         ->where('page_id', NULL)
                //         ->where('position', 'bottom')
                //         ->ordered()->get();
                else if ($this->user_type == "Sponsored") {
                    // ads for sponsored card
                    $this->ads_top = Ad::where('is_active', true)
                        ->where('position', 'top')
                        ->where('is_admin', true)
                        ->where('display_in', 'Sponsored')
                        ->where('sponsor_id', $this->sponsor_id)
                        ->ordered()
                        ->get();

                    $this->ads_bottom = Ad::where('is_active', true)
                        ->where('display_in', 'Sponsored')
                        ->where('sponsor_id', $this->sponsor_id)
                        ->where('position', 'bottom')
                        ->where('is_admin', true)
                        ->ordered()
                        ->get();
                }
                // else if ($this->user_type == "Influencer") {
                //     // ads for sponsored card
                //     $this->ads_top = Ad::where('is_active', true)->where('position', 'top')
                //         ->where('is_admin', true)
                //         ->where('display_in', 'Influencer')
                //         ->where('sponsor_id', $this->sponsor_id)
                //         ->ordered()
                //         ->get();
                //     $this->ads_bottom = Ad::where('is_active', true)->where('position', 'bottom')
                //         ->where('display_in', 'Influencer')
                //         ->where('sponsor_id', $this->sponsor_id)
                //         ->where('is_admin', true)
                //         ->ordered()
                //         ->get();
                // }
                else if (in_array($this->user_type, ['Gold', 'Platinum']) && $this->mainCard) {
                    // if user_type not free and main card
                    // get all ads on position = top
                    $this->ads_top = Ad::where('is_active', true)
                        ->where('is_admin', false)
                        ->where($this->condition)
                        ->where('position', 'top')
                        ->ordered()
                        ->get();

                    // get all ads on position = top
                    $this->ads_bottom = Ad::where('is_active', true)
                        ->where('is_admin', false)
                        ->where($this->condition)
                        ->where('position', 'bottom')
                        ->ordered()
                        ->get();
                } else {
                    // if  sub card
                    // get all ads on position = top
                    $this->ads_top = Ad::where('is_active', true)
                        ->where('is_admin', false)
                        ->where($this->condition)
                        ->where('position', 'top')
                        ->ordered()
                        ->get();


                    // get all ads on position = top
                    $this->ads_bottom = Ad::where('is_active', true)
                        ->where('is_admin', false)
                        ->where($this->condition)
                        ->where('position', 'bottom')
                        ->ordered()
                        ->get();
                }
            }
        } else {
            $this->user = 0;
            $this->card_title = "Not found";
            $this->page_title = "Not found";
            $this->fullname = "Not found";
        }

        $this->displayCard($username);
    }

    public function render()
    {
        // dd($this->user->user_type, $this->trusted_network);
        return view('livewire.card')->title('' . ($this->page_title ?: $this->card_title))->layoutData([
            'favicon' => $this->favicon,
            'username' => $this->username,
            'bio' => $this->bio,
            'firstname' => $this->firstname,
            'lastname' => $this->lastname,
            'video_count' => $this->video_count,
            'site_url' => $this->site_url,
            'app_name' => $this->app_name,
            'ads_top' => $this->ads_top,
            'ads_bottom' => $this->ads_bottom,
            'thumbnail' => $this->thumbnail,
            'title' => $this->page_title ?: $this->card_title,
            'images_count' => $this->images_count,
            'gallery_main' => $this->gallery_main,
            'connect_main' => $this->connect_main,
            'connect_icon' => $this->connect_icon,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
            'color_settings_profile_pic_border' => $this->color_settings_profile_pic_border,
            'button_style' => $this->button_style,
        ]);
    }
}
