<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\SubCard;
use App\Models\User;
use App\Models\UserSettings;
use App\Settings\CardDefaultsSetting;

class CardCustomization extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    //show
    public $footer_text;
    public $footer_link;

    //defaults
    public $card_custom_title;
    public $custom_page_title;

    //get
    public $get_footer_text;
    public $get_footer_link;
    public $get_gallery_main;
    public $get_gallery_bio;

    //shop button for gold and platinum users
    public ?string $shop_text;
    public ?string $shop_more;

    public ?string $services_text;

    public ?string $contact_text;
    public ?string $follow_text;
    public ?string $event_text;
    public ?string $payment_text;

    public $gallery_two_slide;

    public ?string $click_videos;
    public ?string $click_videos_link;

    public ?string $click_gallery;
    public ?string $click_gallery_link;

    //used to check user type to display proper settings
    public $user_type;

    public $page_id; //subcard id, used in query
    public $checkifactive;

    public $query;
    public $user;

    public function updateField($field)
    {
        if (!$this->user) {
            session()->flash('error', 'Unauthorized action.');
            return $this->redirect('/customization/card-customization', navigate: true);
        }

        if ($this->checkifactive > 0) {
            $setting = UserSettings::where('setting_key', $field)
                ->where('user_id', $this->user->id)
                ->whereNull('page_id')
                ->first();
        } else {

            $setting = UserSettings::where('setting_key', $field)
                ->where('page_id', $this->page_id)
                ->first();
        }

        $newValue = !($setting->setting_value ?? false);

        UserSettings::updateOrCreate(
            array_merge(['setting_key' => $field], $this->query),
            ['setting_value' => $newValue]
        );

        session()->flash('success', 'Settings successfully updated!');

        // Redirect to the specified route
        return $this->redirect('/customization/card-customization', navigate: true);
    }

    public function imageSlideSetting()
    {
        $this->updateField('gallery_two_slide');
    }

    public function updateClickVideos()
    {
        // Validate inputs
        $validated = $this->validate([
            'click_videos' => 'required|string',
            'click_videos_link' => 'required|url'
        ], [
            'click_videos.required' => 'Please enter the title.',
            'click_videos_link.required' => 'Please enter the link.',
            'click_videos_link.url' => 'Please enter a valid URL.',
        ]);


        if ($this->user) {
            // Update or create text setting
            UserSettings::updateOrCreate(
                array_merge(['setting_key' => 'click_videos'], $this->query),
                ['setting_value' => $validated['click_videos']]
            );

            // Update or create link setting
            UserSettings::updateOrCreate(
                array_merge(['setting_key' => 'click_videos_link'], $this->query),
                ['setting_value' => $validated['click_videos_link']]
            );

            session()->flash('success', 'Settings successfully updated!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/customization/card-customization', navigate: true);
    }

    public function updateClickGallery()
    {
        // Validate inputs
        $validated = $this->validate([
            'click_gallery' => 'required|string',
            'click_gallery_link' => 'required|url'
        ], [
            'click_gallery.required' => 'Please enter the title.',
            'click_gallery_link.required' => 'Please enter the link.',
            'click_gallery_link.url' => 'Please enter a valid URL.',
        ]);

        if ($this->user) {
            // Update or create text setting
            UserSettings::updateOrCreate(
                array_merge(['setting_key' => 'click_gallery'], $this->query),
                ['setting_value' => $validated['click_gallery']]
            );

            // Update or create link setting
            UserSettings::updateOrCreate(
                array_merge(['setting_key' => 'click_gallery_link'], $this->query),
                ['setting_value' => $validated['click_gallery_link']]
            );

            session()->flash('success', 'Settings successfully updated!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/customization/card-customization', navigate: true);
    }

    public function updateFooterLink()
    {
        // Validate inputs
        $validated = $this->validate([
            'footer_text' => 'required|string',
            'footer_link' => 'required|url'
        ]);

        if ($this->user) {
            // Update or create text setting
            UserSettings::updateOrCreate(
                array_merge(['setting_key' => 'footer_text'], $this->query),
                ['setting_value' => $validated['footer_text']]
            );

            // Update or create link setting
            UserSettings::updateOrCreate(
                array_merge(['setting_key' => 'footer_link'], $this->query),
                ['setting_value' => $validated['footer_link']]
            );

            session()->flash('success', 'Settings successfully updated!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/customization/card-customization', navigate: true);
    }

    public function updateCardText()
    {
        // Validate inputs
        $validated = $this->validate([
            'card_custom_title' => 'nullable|string|max:50',
            'custom_page_title' => 'nullable|string|max:50',
            'contact_text' => 'nullable|string|max:50',
            'follow_text' => 'nullable|string|max:50',
            'event_text' => 'nullable|string|max:50',
            'payment_text' => 'nullable|string|max:50',
            'shop_text' => 'nullable|string|max:50',
            'shop_more' => 'nullable|url|max:500',
            'services_text' => 'nullable|string|max:50',
        ]);

        UserSettings::updateOrCreate(
            array_merge(['setting_key' => 'card_custom_title'], $this->query),
            ['setting_value' => $validated['card_custom_title']]
        );

        UserSettings::updateOrCreate(
            array_merge(['setting_key' => 'custom_page_title'], $this->query),
            ['setting_value' => $validated['custom_page_title']]
        );

        UserSettings::updateOrCreate(
            array_merge(['setting_key' => 'contact_text'], $this->query),
            ['setting_value' => $validated['contact_text']]
        );

        UserSettings::updateOrCreate(
            array_merge(['setting_key' => 'follow_text'], $this->query),
            ['setting_value' => $validated['follow_text']]
        );

        UserSettings::updateOrCreate(
            array_merge(['setting_key' => 'event_text'], $this->query),
            ['setting_value' => $validated['event_text']]
        );

        UserSettings::updateOrCreate(
            array_merge(['setting_key' => 'payment_text'], $this->query),
            ['setting_value' => $validated['payment_text']]
        );

        UserSettings::updateOrCreate(
            array_merge(['setting_key' => 'shop_text'], $this->query),
            ['setting_value' => $validated['shop_text']]
        );

        UserSettings::updateOrCreate(
            array_merge(['setting_key' => 'shop_more'], $this->query),
            ['setting_value' => $validated['shop_more']]
        );

        UserSettings::updateOrCreate(
            array_merge(['setting_key' => 'services_text'], $this->query),
            ['setting_value' => $validated['services_text']]
        );

        // UserSettings::updateOrCreate(
        //     array_merge(['setting_key' => 'click_gallery'], $query),
        //     ['setting_value' => $validated['click_gallery']]
        // );

        session()->flash('success', 'Settings updated successfully!');

        return $this->redirect('/customization/card-customization', navigate: true);
    }

    public function viewSettings()
    {

        // Footer Text
        $this->get_footer_text = UserSettings::where('setting_key', 'footer_text')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        // Footer Link
        $this->get_footer_link = UserSettings::where('setting_key', 'footer_link')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        // Shop text
        $this->services_text = UserSettings::where('setting_key', 'services_text')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        // Shop More
        $this->shop_more = UserSettings::where('setting_key', 'shop_more')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        // Card title
        $this->card_custom_title = UserSettings::where('setting_key', 'card_custom_title')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        // Page title
        $this->custom_page_title = UserSettings::where('setting_key', 'custom_page_title')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        // Follow text
        $this->follow_text = UserSettings::where('setting_key', 'follow_text')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        // Event text
        $this->event_text = UserSettings::where('setting_key', 'event_text')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        // Contact text
        $this->contact_text = UserSettings::where('setting_key', 'contact_text')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        // Bio text
        $this->payment_text = UserSettings::where('setting_key', 'payment_text')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        $this->click_gallery = UserSettings::where('setting_key', 'click_gallery')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        $this->click_gallery_link = UserSettings::where('setting_key', 'click_gallery_link')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        $this->click_videos = UserSettings::where('setting_key', 'click_videos')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        $this->click_videos_link = UserSettings::where('setting_key', 'click_videos_link')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();

        // Country enabled
        $this->gallery_two_slide = UserSettings::where($this->query)
            ->where('setting_key', 'gallery_two_slide')
            ->pluck('setting_value')
            ->first();

        $this->gallery_two_slide = $this->gallery_two_slide ?: true;

        $this->follow_text = $this->follow_text ?: 'Follow me';
        $this->event_text = $this->event_text ?: 'Events';
        $this->contact_text = $this->contact_text ?: 'Contact me';
        $this->payment_text = $this->payment_text ?: 'Payment Links';

        $this->click_videos = $this->click_videos ?: 'Click here';
        $this->click_videos_link = $this->click_videos_link ?: '';

        $this->click_gallery = $this->click_gallery ?: 'Click here';
        $this->click_gallery_link = $this->click_gallery_link ?: '';

        $this->services_text = $this->services_text ?: 'Services';

        if (!$this->card_custom_title) {
            if ($this->checkifactive > 0) {
                $this->card_custom_title = $this->user->firstname . ' ' . $this->user->lastname;
            } else {
                $this->card_custom_title = SubCard::where('id', $this->page_id)->pluck('firstname')->first() . ' ' . SubCard::where('id', $this->page_id)->pluck('lastname')->first();
            }
        }

        if (!$this->custom_page_title) {
            if ($this->checkifactive > 0) {
                $this->custom_page_title = $this->card_custom_title ?: $this->user->firstname . ' ' . $this->user->lastname;
            } else {
                $this->custom_page_title = $this->card_custom_title ?: SubCard::where('id', $this->page_id)->pluck('firstname')->first() . ' ' . SubCard::where('id', $this->page_id)->pluck('lastname')->first();
            }
        }
    }

    public function mount()
    {
        $this->user = auth()->user();
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->checkifactive = User::where('id', $this->user->id)->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->query = ['user_id' => $this->user->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', $this->user->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->query = ['page_id' => $this->page_id];
        }

        $this->footer_text = $this->get_footer_text;
        $this->footer_link = $this->get_footer_link;

        $this->user_type = $this->user->user_type;

        $this->viewSettings();
    }

    public function render()
    {
        return view('pages.card-customization')->title('Card Customization | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
