<?php

namespace App\Livewire;

use App\Models\Analytics;
use Livewire\Component;
use App\Models\User;
use App\Models\SubCard;
use Carbon\Carbon;

class CardViewTracker extends Component
{
    public $user_id;
    public $checkMain;
    public bool $mainCard = false;
    public $page_id;

    protected $listeners = ['countCardView'];

    public function countCardView($referrer, $device, $location)
    {
        if ($this->mainCard == true) {
            //main card
            if (!$referrer) {
                $referrer = NULL;
            }

            $existingView = Analytics::where('ip_address', $location['ip'] ?? null)
                ->where('device_type', $device)
                ->where('user_id', $this->user_id)
                ->where('page_id', NULL)
                ->where('type', 'card_view')
                ->whereDate('viewed_at', Carbon::today())
                ->first();

            if (!$existingView) {
                Analytics::create([
                    'user_id'     => $this->user_id,
                    'page_id'     => NULL,
                    'referrer'    => $referrer ?? null,
                    'device_type' => $device,
                    'ip_address'  => $location['ip'] ?? null,
                    'city'        => $location['city'] ?? null,
                    'region'      => $location['region'] ?? null,
                    'country'     => $location['country'] ?? null,
                    'viewed_at'   => now(),
                    'type'        => 'card_view'
                ]);
            }
        } else {
            //subcard
            $existingView = Analytics::where('ip_address', $location['ip'] ?? null)
                ->where('device_type', $device)
                ->where('user_id', $this->user_id)
                ->where('page_id', $this->page_id)
                ->where('type', 'card_view')
                ->whereDate('viewed_at', Carbon::today())
                ->first();

            if (!$existingView) {
                Analytics::create([
                    'user_id'     => $this->user_id,
                    'page_id'     => $this->page_id,
                    'referrer'    => $referrer ?? null,
                    'device_type' => $device,
                    'ip_address'  => $location['ip'] ?? null,
                    'city'        => $location['city'] ?? null,
                    'region'      => $location['region'] ?? null,
                    'country'     => $location['country'] ?? null,
                    'viewed_at'   => now(),
                    'type'        => 'card_view'
                ]);
            }
        }
    }

    public function mount($username)
    {
        //used to determine where to check if the username exist
        $this->checkMain = User::where('username', $username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();
        } else {
            $this->mainCard = false;
            $this->page_id = SubCard::where('username', $username)
                ->pluck('id')
                ->first();

            $this->user_id = SubCard::where('username', $username)
                ->pluck('user_id')
                ->first();
        }
    }

    public function render()
    {
        return view('livewire.card-view-tracker');
    }
}
