<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;
use App\Settings\CardDefaultsSetting;

class ChangePassword extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $old_password;
    public $password;
    public $password_confirmation;

    // This function updates the password
    public function updatePassword()
    {
        // Validate inputs
        $validated = $this->validate(
            [
                'old_password' => 'required|string',
                'password' => 'required|string|min:8|confirmed',
            ],
            // Custom error messages
            ['password.confirmed' => "Password didn't match."]
        );

        if (auth()->user()) {
            // Check if the old password is correct by comparing it to the stored hashed password
            $user = auth()->user();

            if (Hash::check($this->old_password, $user->password)) {
                // If the old password matches, update the password
                $user->password = Hash::make($this->password);
                $user->save();

                session()->flash('success', 'Password successfully updated!');
            } else {
                // If the old password does not match
                session()->flash('error', 'Old password didn\'t match!');
            }
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        // Redirect to the change password page after action
        return redirect()->route('password.index');
    }

    // Render the view
    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        return view('livewire.change-password')->title('Change Password | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
