<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\SubCard;
use App\Models\User;
use App\Models\UserSettings;

class ColorPickerModal extends Component
{
    public $selected_color_setting;
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_link;
    public $color_settings_profile_pic_border;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;
    public $color;

    public $checkifactive;
    public $page_id;
    public $query;
    public $setting;
    public $condition;

    protected $listeners = ['selected_color_setting', 'set_color'];

    public function selected_color_setting($value)
    {
        $this->selected_color_setting = $value;
    }

    public function set_color($value)
    {
        $this->color = $value;
    }

    public function save_custom_colors()
    {
        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
            $this->query = ['user_id' => auth()->user()->id, 'page_id' => NULL, 'setting_value' =>  $this->color];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            // $this->condition = ['user_id' => NULL, 'page_id' => $this->page_id];
            // $this->query = ['user_id' => NULL, 'page_id' => $this->page_id, 'setting_value' =>  $this->color];

            $this->condition = ['page_id' => $this->page_id];
            $this->query = ['page_id' => $this->page_id, 'setting_value' =>  $this->color];
        }

        //color_settings_custom_button
        if ($this->selected_color_setting == 'color_settings_custom_button') {

            $this->setting = UserSettings::where('setting_key', 'color_settings_custom_button')
                ->where($this->condition)
                ->first();

            if ($this->setting) {
                $update = $this->setting->update(array_merge(
                    $this->query
                ));
            } else {
                $update = UserSettings::create(array_merge(
                    [
                        'setting_key' => 'color_settings_custom_button',
                    ],
                    $this->query
                ));
            }

            if ($update) {
                session()->flash('success', 'Custom button color successfully updated!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }
        } else if ($this->selected_color_setting == 'color_settings_custom_button_text') {

            $this->setting = UserSettings::where('setting_key', 'color_settings_custom_button_text')
                ->where($this->condition)
                ->first();

            if ($this->setting) {
                $update = $this->setting->update(array_merge(
                    $this->query
                ));
            } else {
                $update = UserSettings::create(array_merge(
                    [
                        'setting_key' => 'color_settings_custom_button_text',
                    ],
                    $this->query
                ));
            }

            if ($update) {
                session()->flash('success', 'Button text color successfully updated!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }
        } else if ($this->selected_color_setting == 'color_settings_link') {
            $this->setting = UserSettings::where('setting_key', 'color_settings_link')
                ->where($this->condition)
                ->first();

            if ($this->setting) {
                $update = $this->setting->update(array_merge(
                    $this->query
                ));
            } else {
                $update = UserSettings::create(array_merge(
                    [
                        'setting_key' => 'color_settings_link',
                    ],
                    $this->query
                ));
            }

            if ($update) {
                session()->flash('success', 'Link color successfully updated!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }
        } else if ($this->selected_color_setting == 'color_settings_profile_pic_border') {
            $this->setting = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
                ->where($this->condition)
                ->first();

            if ($this->setting) {
                $update = $this->setting->update(array_merge(
                    $this->query
                ));
            } else {
                $update = UserSettings::create(array_merge(
                    [
                        'setting_key' => 'color_settings_profile_pic_border',
                    ],
                    $this->query
                ));
            }

            if ($update) {
                session()->flash('success', 'Profile picture border color successfully updated!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }
        } else if ($this->selected_color_setting == 'color_settings_card_light') {
            $this->setting = UserSettings::where('setting_key', 'color_settings_card_light')
                ->where($this->condition)
                ->first();

            if ($this->setting) {
                $update = $this->setting->update(array_merge(
                    $this->query
                ));
            } else {
                $update = UserSettings::create(array_merge(
                    [
                        'setting_key' => 'color_settings_card_light',
                    ],
                    $this->query
                ));
            }

            if ($update) {
                session()->flash('success', 'Background color (Light Mode) successfully updated!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }
        } else if ($this->selected_color_setting == 'color_settings_card_dark') {
            $this->setting = UserSettings::where('setting_key', 'color_settings_card_dark')
                ->where($this->condition)
                ->first();

            if ($this->setting) {
                $update = $this->setting->update(array_merge(
                    $this->query
                ));
            } else {
                $update = UserSettings::create(array_merge(
                    [
                        'setting_key' => 'color_settings_card_dark',
                    ],
                    $this->query
                ));
            }

            if ($update) {
                session()->flash('success', 'Background color (Dark Mode) successfully updated!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }
        }
        // Text Color Settings
        else if ($this->selected_color_setting == 'color_settings_text_light') {
            $this->setting = UserSettings::where('setting_key', 'color_settings_text_light')
                ->where($this->condition)
                ->first();

            if ($this->setting) {
                $update = $this->setting->update(array_merge(
                    $this->query
                ));
            } else {
                $update = UserSettings::create(array_merge(
                    [
                        'setting_key' => 'color_settings_text_light',
                    ],
                    $this->query
                ));
            }

            if ($update) {
                session()->flash('success', 'Text color (Light Mode) successfully updated!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }
        } else if ($this->selected_color_setting == 'color_settings_text_dark') {
            $this->setting = UserSettings::where('setting_key', 'color_settings_text_dark')
                ->where($this->condition)
                ->first();

            if ($this->setting) {
                $update = $this->setting->update(array_merge(
                    $this->query
                ));
            } else {
                $update = UserSettings::create(array_merge(
                    [
                        'setting_key' => 'color_settings_text_dark',
                    ],
                    $this->query
                ));
            }

            if ($update) {
                session()->flash('success', 'Text color (Dark Mode) successfully updated!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        // Redirect to the specified route
        return redirect('/appearance/colors');
    }


    public function mount()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_link = UserSettings::where('setting_key', 'color_settings_link')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Background Color Settings
        $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Text Color Settings
        $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // if no value, set default colors
        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
        $this->color_settings_link = $this->color_settings_link ?: '#ca8a04';
        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
        $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
        $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
        $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';
    }

    public function render()
    {
        // dd($this->color_settings_text_dark, $this->color_settings_text_light);
        return view('livewire.color-picker-modal');
    }
}
