<?php

namespace App\Livewire;

use App\Models\LetsConnect;
use Livewire\Component;
use App\Models\User;
use App\Models\SubCard;
use App\Settings\CardDefaultsSetting;

class ContactPageSubmitted extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $contact_info;
    public $user;

    public $favicon;
    public $bio;

    public $username, $firstname, $lastname, $phone, $gender, $profile_pic, $job_title, $we_met_at, $company, $company_website, $country, $email;

    public $page_id;

    public function __construct()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;
    }

    public function mount($id)
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            //get user id
            $this->contact_info = LetsConnect::where('id', $id)->where('user_id', auth()->user()->id)->first();
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->contact_info = LetsConnect::where('id', $id)->where('page_id',  $this->page_id)->first();
        }

        if (!$this->contact_info) {
            abort(404, 'Page not found.');
        }
    }

    public function render()
    {
        return view('livewire.contact-page-submitted')->title('Contact | ' . $this->contact_info->firstname . '' . $this->contact_info->lastname)->layoutData([
            // 'favicon' => $this->favicon,
            'firstname' => $this->firstname,
            'lastname' => $this->lastname,
            'site_url' => $this->site_url,
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
