<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Button;
use App\Models\User;
use App\Models\SubCard;
use App\Models\UserSettings;

class ContactPointsComponent extends Component
{

    public $user_id;
    public $username;
    public $link;
    public $title;

    public bool $mainCard = false;
    public $page_id;
    public $user;

    public $checkMain;
    public $checkSub;
    public $contacts;

    public $color_settings_custom_button;
    public $color_settings_custom_button_text;

    public $condition;
    public $query;

    public function mount($username)
    {
        //used to determine where to check if the username exist
        $this->checkMain = User::where('username', $username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();

            $this->condition = ['user_id' => $this->user_id, 'page_id' => NULL];
        } else {
            $this->mainCard = false;
            $this->page_id = SubCard::where('username', $username)
                ->pluck('id')
                ->first();

            $this->user_id = SubCard::where('username', $username)
                ->pluck('user_id')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }

        $this->contacts = Button::where('view', 'contacts')->where($this->condition)->where('is_active', true)->get();
        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
    }

    public function render()
    {
        return view('livewire.contact-points-component');
    }
}
