<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Database\Eloquent\Model;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Attributes\Validate;
use Livewire\Attributes\On;
use App\Models\SubCard;
use App\Models\User;

class CoverImageField extends Component
{

    use WithFileUploads;

    public Model $model;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]
    public $image;

    public ?string $croppedBlob;

    public $page_id;
    public $image_path;

    // public function deleteCoverPhoto()
    // {
    //     $checkifactive = User::where('id', auth()->user()->id)->where('active_card', true)->exists();
    //     if ($checkifactive > 0) {

    //         $this->image_path = User::where('id', auth()->user()->id)->value('cover_pic');
    //         $deleteCover = User::where('id', auth()->user()->id)->update(['cover_pic' => null]);
    //     } else {
    //         $this->page_id = SubCard::where('user_id', auth()->user()->id)
    //             ->where('active_card', true)
    //             ->value('id');

    //         $this->image_path = SubCard::where('id', $this->page_id)->value('cover_pic');
    //         $deleteCover = SubCard::where('id', $this->page_id)->update(['cover_pic' => null]);
    //     }

    //     // Safely delete the file if it exists
    //     if ($this->image_path) {
    //         $path = storage_path('app/public/' . $this->image_path);
    //         // $path = 'app/public/' . $this->image_path;
    //         if (file_exists($path)) {
    //             unlink($path);
    //         }
    //     }

    //     if ($deleteCover) {
    //         session()->flash('success', 'Cover photo successfully removed.');
    //     } else {
    //         session()->flash('error', 'Unauthorized action.');
    //     }

    //     return redirect()->route('profile.edit');
    // }

    public function deleteCoverPhoto()
    {
        $user = auth()->user();
        $isMainCard = User::where('id', $user->id)->where('active_card', true)->exists();

        if ($isMainCard) {
            $this->image_path = $user->cover_pic;

            // Update via Eloquent (fires model events)
            $user->cover_pic = null;
            $deleteCover = $user->save(); // ✅ triggers updating/updated
        } else {
            $subCard = SubCard::where('user_id', $user->id)
                ->where('active_card', true)
                ->first();

            if ($subCard) {
                $this->page_id = $subCard->id;
                $this->image_path = $subCard->cover_pic;

                $subCard->cover_pic = null;
                $deleteCover = $subCard->save(); // ✅ triggers model events
            } else {
                $deleteCover = false;
            }
        }

        // Safely delete the file if it exists
        if (!empty($this->image_path)) {
            $path = storage_path('app/public/' . $this->image_path);
            if (file_exists($path)) {
                unlink($path);
            }
        }

        if ($deleteCover) {
            session()->flash('success', 'Cover photo successfully removed.');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return redirect()->route('profile.edit');
    }

    public function render()
    {
        return view('livewire.cover-image-field');
    }
}
