<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\WithFileUploads;
use Illuminate\Database\Eloquent\Model;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use Spatie\Image\Image;
use App\Models\User;
use App\Models\SubCard;
use App\Models\UserSettings;

class CoverImageModal extends Component
{
    use WithFileUploads;

    public Model $model;

    public $temporaryUrl;
    public ?string $croppedBlob;
    public $cover_pic;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;
    public $query;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heic,heif|max:5120')]
    public $image;

    public function handleCroppedImage($croppedBlob, $cropRegions, $imageSize)
    {
        Image::load($this->image->getRealPath())->width($imageSize['naturalWidth'])->height($imageSize['naturalHeight'])
            ->save();

        Image::load($this->image->getRealPath())
            ->manualCrop($cropRegions['width'], $cropRegions['height'], $cropRegions['x'], $cropRegions['y'])
            ->save();

        $this->croppedBlob = $croppedBlob;
        $this->cover_pic = new TemporaryUploadedFile($this->image->getRealPath(), config('filesystems.default'));
    }

    // public function updateCover()
    // {
    //     // check if user is logged in
    //     if (auth()->user()) {

    //         if ($this->cover_pic) {
    //             // if main card
    //             if ($this->mainCard) {
    //                 // Check if the user already has a cover photo and delete it
    //                 if (auth()->user()->cover_pic && file_exists(storage_path('app/public/' . auth()->user()->cover_pic))) {
    //                     // Delete the old profile picture
    //                     unlink(storage_path('app/public/' . auth()->user()->cover_pic));
    //                 }

    //                 auth()->user()->cover_pic = $this->cover_pic->storePublicly('cover_pic', 'public');
    //                 // Update the user data
    //                 $updated = auth()->user()
    //                     ->update([
    //                         'cover_pic' => $this->cover_pic->storePublicly('cover_pic', 'public')
    //                     ]);

    //                 $this->query = ['user_id' => auth()->user()->id, 'page_id' => NULL];
    //             } else {
    //                 // if subcard
    //                 // Check if the user already has a profile picture and delete it
    //                 $checkSubCardCover = SubCard::where('active_card', true)->where('user_id', auth()->user()->id)->pluck('cover_pic')->first();

    //                 if ($checkSubCardCover && file_exists(storage_path('app/public/' . $checkSubCardCover))) {
    //                     // Delete the old profile picture
    //                     unlink(storage_path('app/public/' . $checkSubCardCover));
    //                 }

    //                 $updated = auth()->user()->subcards()
    //                     ->where('active_card', true)
    //                     ->update([
    //                         'cover_pic' => $this->cover_pic->storePublicly('cover_pic', 'public')
    //                     ]);

    //                 $this->query = ['user_id' => NULL, 'page_id' => $this->page_id];
    //             }

    //             if ($updated) {
    //                 session()->flash('success', 'Cover photo successfully updated.');

    //                 UserSettings::where($this->query)
    //                     ->update(
    //                         [
    //                             'setting_key' => 'profile_layout',
    //                             'setting_value' => 'default_cover'
    //                         ]
    //                     );
    //             } else {
    //                 session()->flash('error', 'Error in updating cover photo.');
    //             }

    //             $tempFilePath = $this->cover_pic->getRealPath();

    //             if (file_exists($tempFilePath)) {
    //                 unlink($tempFilePath);  // Delete the temporary file explicitly
    //             }
    //         }
    //     } else {
    //         session()->flash('error', 'Unauthorized action.');
    //     }
    //     return redirect()->route('profile.edit');
    // }

    public function updateCover()
    {
        if (!auth()->check()) {
            session()->flash('error', 'Unauthorized action.');
            return redirect()->route('profile.edit');
        }

        if (!$this->cover_pic) {
            session()->flash('error', 'No cover photo selected.');
            return redirect()->route('profile.edit');
        }

        $user = auth()->user();
        $newCoverPath = $this->cover_pic->storePublicly('cover_pic', 'public');
        $updated = false;

        if ($this->mainCard) {
            // Delete old cover photo if it exists
            if ($user->cover_pic && file_exists(storage_path("app/public/{$user->cover_pic}"))) {
                unlink(storage_path("app/public/{$user->cover_pic}"));
            }

            $user->cover_pic = $newCoverPath;
            $updated = $user->save(); // ✅ Triggers `updating` event

            $this->query = ['user_id' => $user->id, 'page_id' => null];
        } else {
            // Subcard case
            $activeSubCard = $user->subcards()->where('active_card', true)->first();

            if ($activeSubCard) {
                if ($activeSubCard->cover_pic && file_exists(storage_path("app/public/{$activeSubCard->cover_pic}"))) {
                    unlink(storage_path("app/public/{$activeSubCard->cover_pic}"));
                }

                $activeSubCard->cover_pic = $newCoverPath;
                $updated = $activeSubCard->save(); // ✅ Triggers `updating` if needed

                // $this->query = ['user_id' => null, 'page_id' => $this->page_id];
                $this->query = ['page_id' => $this->page_id];
            }
        }

        if ($updated) {
            session()->flash('success', 'Cover photo successfully updated.');

            UserSettings::where($this->query)
                ->where('setting_key', 'profile_layout')
                ->update([
                    'setting_value' => 'default_cover',
                ]);
        } else {
            session()->flash('error', 'Error in updating cover photo.');
        }

        // Clean up Livewire temp file
        if (file_exists($this->cover_pic->getRealPath())) {
            unlink($this->cover_pic->getRealPath());
        }

        return redirect()->route('profile.edit');
    }

    // After uploading the image, manually validate. if image is valid, display on the modal
    public function updatedImage()
    {
        try {
            $this->validate([
                'image' => 'mimes:jpeg,png,jpg,webp,heif,heic|max:5120',
            ]);

            $this->temporaryUrl = $this->image->temporaryUrl();
        } catch (\Illuminate\Validation\ValidationException $e) {

            session()->flash('error', 'The file must be an image (jpeg, png, jpg, heic, heif or webp).');

            return redirect()->route('profile.edit');
        }
    }

    public function mount()
    {
        $this->checkMain = User::where('id', auth()->user()->id)->count();
        $this->checkSub = SubCard::where('user_id', auth()->user()->id)->where('active_card', true)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->first();
            $this->mainCard = false;
        }
    }

    public function render()
    {
        return view('livewire.cover-image-modal');
    }
}
