<?php

namespace App\Livewire;

use App\Models\Analytics;
use App\Models\Button;
use App\Models\LetsConnect;
use App\Models\Network;
use App\Models\Product;
use App\Models\Social;
use App\Models\SubCard;
use App\Models\User;
use App\Settings\CardDefaultsSetting;
use App\Models\UserSettings;
use App\Models\Video;
use Livewire\Component;
use Carbon\Carbon;

class Dashboard extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $term_basic;
    public $term_gold;
    public $term_platinum;

    public $card_title;
    public $query;

    public $user;
    public $social_count;
    public $button_count;
    public $product_count;
    public $video_count;
    public $card_view_count;
    public $button_analytics;
    public $firstname, $lastname;

    public $platinum_enabled;

    public $network_saved, $network_added, $network_form;
    public $page_id; //subcard id, used in query

    public $card_view_analytics_by_month;

    public $months;
    public $days;
    public $checkifactive;

    public function showAnalytics()
    {
        $year = Carbon::now()->year;
        $cardViewCounts = [];

        for ($month = 1; $month <= 12; $month++) {
            //card_view
            $card_view_count = Analytics::where($this->query)
                ->where('type', 'card_view')
                ->whereMonth('viewed_at', $month)
                ->whereYear('viewed_at', $year)
                ->count();

            $cardViewCounts[Carbon::create()->month($month)->format('M')] = $card_view_count;
        }

        $this->card_view_analytics_by_month = $cardViewCounts;
    }

    public function showDashboard()
    {
        $this->social_count = Social::where($this->query)->count();
        // $this->button_count = Button::where('view', 'links')->where($this->query)->count();
        $this->button_count = auth()->user()
            ->buttons()
            ->where('view', 'links')
            ->when(!in_array($this->user->user_type, ['Platinum']), fn($q) => $q->whereNot('type', 'trusted_network'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'reviews'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'zoom_replay'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'team'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'services'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'shop'))
            ->when(!in_array($this->user->user_type, ['Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'bio'))
            ->when(!in_array($this->user->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'events'))
            ->when(!in_array($this->user->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'payments'))
            ->when(!in_array($this->user->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'help'))
            ->when(!in_array($this->user->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'exchange'))
            ->when(!in_array($this->user->user_type, ['Basic', 'Gold', 'Platinum']), fn($q) => $q->whereNot('type', 'feedback'))
            ->where($this->query)
            ->count();

        $this->product_count = Product::where($this->query)->count();
        $this->video_count = Video::where($this->query)->count();

        $this->card_view_count = Analytics::where($this->query)->where('type', 'card_view')->count();

        $this->button_analytics = Analytics::where($this->query)->where('type', 'button_click')->count();

        //network stuff
        $this->network_saved = Network::where($this->query)->where('type', 'saved')->count();
        $this->network_added = LetsConnect::where($this->query)->where('type', 'added')->count();
        $this->network_form = LetsConnect::where($this->query)->where('type', 'submission')->count();

        // Card title
        $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
            ->where($this->query)
            ->pluck('setting_value')
            ->first();
    }

    public function mount()
    {

        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic', 'user_type', 'access']);

            $this->firstname = $this->user->firstname;
            $this->lastname = $this->user->lastname;

            $this->query = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.user_id', auth()->user()->id)
                ->where('subcards.active_card', true)
                ->first([
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'subcards.firstname as subcard_firstname',
                    'subcards.lastname as subcard_lastname',
                    'users.firstname as user_firstname',
                    'users.lastname as user_lastname',
                    'users.user_type',
                    'users.access',
                ]);

            // set firstname
            if (!$this->user->subcard_firstname) {
                $this->firstname = $this->user->user_firstname;
            } else {
                $this->firstname = $this->user->subcard_firstname;
            }

            // set lastname
            if (!$this->user->subcard_lastname) {
                $this->lastname = $this->user->user_lastname;
            } else {
                $this->lastname = $this->user->subcard_lastname;
            }

            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->query = ['page_id' => $this->page_id];
        }

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->site_url = $default->site_url;
        $this->app_name = $default->app_name;
        $this->platinum_enabled = $default->platinum_enabled;

        //Terms
        $this->term_basic = $default->term_basic;
        $this->term_gold = $default->term_gold;
        $this->term_platinum = $default->term_platinum;

        $this->showDashboard();
        $this->showAnalytics();
    }

    public function render()
    {
        return view('pages.dashboard', [
            'site_url' => $this->site_url,
            'user' => $this->user,
            'social_count' => $this->social_count,
            'button_count' => $this->button_count,
            'product_count' => $this->product_count,
            'video_count' => $this->video_count,
            'card_view_count' => $this->card_view_count,
            'button_analytics' => $this->button_analytics,
            'firstname' => $this->firstname,
            'lastname' => $this->lastname,
        ])->title('Dashboard | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
