<?php

namespace App\Livewire;

use App\Models\SubCard;
use App\Models\User;
use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use App\Models\UserSettings;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class DefaultAdminAdsForFreeUser extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $default_ads_enabled;
    public $default_ads;
    public $ad_items;

    public $ads;
    public $user_type;

    public $user;
    public $test;

    public $page_id; //subcard id, used in query

    // public function saveLinks()
    // {
    //     if (!$this->ads || !is_array($this->ads)) {
    //         return;
    //     }

    //     foreach ($this->ads as $index => $data) {

    //         // setting key example: ads.0.user_link
    //         $settingKey = "ads.$index.user_link";

    //         UserSettings::updateOrCreate(
    //             [
    //                 'user_id'  => auth()->id(),
    //                 'page_id'  => $this->page_id,   // null for main card
    //                 'setting_key' => $settingKey,
    //             ],
    //             [
    //                 'setting_value' => $data['user_link'] ?? null,
    //             ]
    //         );
    //     }

    //     session()->flash('message', 'Ad links updated successfully!');
    // }

    public function saveLinks()
    {
        dd($this->test);
        // if (!$this->ads || !is_array($this->ads)) {
        //     return;
        // }

        // foreach ($this->ads as $index => $data) {

        //     // skip if ad is inactive (user can't edit it)
        //     if (empty($this->ad_items[$index]['is_active'])) {
        //         continue;
        //     }

        //     $settingKey = "ads.$index.user_link";

        //     UserSettings::updateOrCreate(
        //         [
        //             'user_id'  => auth()->id(),
        //             'page_id'  => $this->page_id,
        //             'setting_key' => $settingKey,
        //         ],
        //         [
        //             'setting_value' => $data['user_link'] ?? null,
        //         ]
        //     );
        // }

        session()->flash('message', 'Ad links updated successfully!');
    }



    public function adsManager()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        // if active, get the datas and set to form
        if ($checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic', 'user_type']);

            $this->default_ads = UserSettings::where('setting_key', 'like', 'ads.%')
                ->where('user_id', auth()->user()->id)
                ->where('page_id', NULL)
                ->pluck('setting_value', 'setting_key')
                ->toArray();
        } else {

            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.user_id', auth()->user()->id)
                ->where('subcards.active_card', true)
                ->first([
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'users.firstname',
                    'users.lastname',
                    'users.user_type',
                ]);

            // if main card is not active, get the infos from subcard
            // $this->maincard_active = false;
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->default_ads = UserSettings::where('setting_key', 'like', 'ads.%')
                ->where('page_id', $this->page_id)
                ->pluck('setting_value', 'setting_key')
                ->toArray();
        }

        $this->user_type = auth()->user()->user_type;
    }

    // public function mount()
    // {
    //     $default = app(CardDefaultsSetting::class);
    //     $this->site_name = $default->site_name;
    //     $this->thumbnail = $default->thumbnail;
    //     $this->default_ads_enabled = $default->default_ads_enabled;
    //     $this->ad_items = $default->ad_items;

    //     // Initialize ads array for the form
    //     $this->ads = [];

    //     foreach ($this->ad_items as $index => $item) {
    //         $settingKey = "ads.$index.user_link";

    //         $this->ads[$index]['user_link'] = $this->default_ads[$settingKey] ?? '';
    //     }

    //     if ($this->default_ads_enabled == false) {
    //         abort(403, 'Access denied');
    //     }

    //     $this->adsManager();
    // }

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);

        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->default_ads_enabled = $default->default_ads_enabled;
        $this->ad_items = $default->ad_items;

        if ($this->default_ads_enabled == false) {
            abort(403, 'Access denied');
        }

        // ⛔ MUST RUN FIRST — loads user + default_ads correctly
        $this->adsManager();

        // Initialize ads array for the form AFTER default_ads is loaded
        $this->ads = [];

        foreach ($this->ad_items as $index => $item) {
            $settingKey = "ads.$index.user_link";

            $this->ads[$index]['user_link'] = $this->default_ads[$settingKey] ?? '';
        }
    }


    public function render()
    {
        // $this->authorize('view', Ad::class);
        // dd($this->default_ads);
        return view('livewire.default-admin-ads-for-free-user')
            ->title('Ads Management | ' . $this->site_name)->layoutData([
                'thumbnail' => $this->thumbnail,
            ]);
    }
}
