<?php

namespace App\Livewire;

use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\ProductCollection;
use Livewire\Component;
use App\Models\User;
use App\Models\SubCard;
use App\Models\UserSettings;
use App\Settings\CardDefaultsSetting;

class DisplayProductCollection extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $card_title;
    public $page_title;
    public $app_name;

    public $username;
    public $products;
    public $product_collection;
    public $user;
    public $fullname;
    public $favicon;

    public $customFooter = false;

    //footer by user
    public ?bool $footer_enabled;

    public ?string $footer_text;
    public ?string $footer_link;

    public $shop_title;
    public $product_price_enabled;

    //footer by user
    public ?string $default_footer_text;
    public ?string $default_footer_link;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    public $user_id;
    public $condition;
    public $collection_id;

    public $color_settings_link;
    public $color_settings_profile_pic_border;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    public $shop_thumbnail;

    //profile layout
    public $profile_layout;

    public function displayCard($username)
    {
        // get user creds
        $this->username = $username;

        if ($this->mainCard == true) {
            $this->user = User::where('username', $this->username)->where('is_active', true)->first(['email', 'phone', 'profile_pic', 'cover_pic', 'thumbnail', 'username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'language', 'address', 'country', 'id', 'user_type']);
        } else {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.username', $this->username)
                ->first([
                    'subcards.id',
                    'subcards.user_id',
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'subcards.cover_pic',
                    'subcards.thumbnail as thumbnail',
                    'users.firstname',
                    'users.lastname',
                    'users.address',
                    'users.country',
                    'users.user_type',
                    'subcards.email',
                    'subcards.phone',
                    'users.id',
                ]);
        }

        if (!isset($this->username)) {
            $this->user = 0;
        }

        // If user exist
        if ($this->user) {
            // Set the fullanme
            $this->fullname = $this->user->firstname . ' ' . $this->user->lastname;

            $this->product_collection = ProductCollection::where($this->condition)
                ->where('id', $this->collection_id)
                ->where('is_active', true)
                ->first();

            $this->products = Product::where($this->condition)
                // ->where('collection_id', $this->collection_id)
                ->whereJsonContains('collection_id', (int) $this->collection_id)
                ->where('is_active', true)
                ->orderBy('order', 'asc')
                ->get();
            // ->filter(fn($product) => $product->is_deal_active);

            // dd($this->products);

            // Page title
            $this->page_title = UserSettings::where('setting_key', 'custom_page_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Card title
            $this->card_title = UserSettings::where($this->condition)
                ->where('setting_key', 'card_custom_title')
                ->pluck('setting_value')
                ->first();

            //product price
            $this->product_price_enabled = UserSettings::where('setting_key', 'product_price_enabled')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //Shop
            $this->shop_title = UserSettings::where('setting_key', 'shop_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Footer enabled
            $this->footer_enabled = UserSettings::where('setting_key', 'footer_enabled')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->footer_text = UserSettings::where('setting_key', 'footer_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->footer_link = UserSettings::where('setting_key', 'footer_link')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->footer_enabled = $this->footer_enabled ?? true;
            $this->shop_title = $this->shop_title ?? 'Shop';

            // if NULL, set to TRUE
            $this->product_price_enabled = $this->product_price_enabled ?? true;


            if ($this->footer_text && $this->footer_link) {
                $this->customFooter = true;
            }

            if ($this->products->isEmpty()) {
                $this->products = 0;
            }

            if (!$this->page_title) {
                $this->page_title = $this->card_title;
            }

            if (!$this->card_title) {
                $this->card_title = $this->fullname;
            }
        } else {
            $this->user = 0;
            $this->card_title = "Not found";
            $this->fullname = "Not found";
        }
    }

    public function __construct()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;

        $this->default_footer_text = $default->footer_text;
        $this->default_footer_link = $default->footer_link;
    }

    public function mount($username, $collection_id)
    {
        // $this->collection_id = $collection_id;
        if ($this->collection_id) {
            $this->products = Product::where($this->condition)
                ->whereJsonContains('collection_id', (int) $this->collection_id)
                ->where('is_active', true)
                ->orderBy('order', 'asc')
                ->get();
        } else {
            $this->products = collect(); // empty
        }


        $default = app(CardDefaultsSetting::class);

        // Default site values
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->favicon = $default->thumbnail;
        $this->app_name = $default->app_name;

        //used to determine where to check if the username exist
        $this->checkMain = User::where('username', $this->username)->count();
        $this->checkSub = SubCard::where('username', $this->username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)
                ->where('is_active', true)
                ->pluck('id')
                ->first();
            $this->condition = ['user_id' => $this->user_id, 'page_id' => NULL];
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('username', $this->username)
                ->pluck('id')
                ->first();
            $this->mainCard = false;
            $this->condition = ['page_id' => $this->page_id];
        }

        // Get color and layout settings
        $this->color_settings_link = UserSettings::where('setting_key', 'color_settings_link')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->profile_layout = UserSettings::where('setting_key', 'profile_layout')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Shop thumbnail
        $this->shop_thumbnail = UserSettings::where('setting_key', 'shop_thumbnail')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Default values / fallbacks
        $this->profile_layout = $this->profile_layout ?? 'default';
        $this->color_settings_link = $this->color_settings_link ?: '#ca8a04';
        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
        $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
        $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
        $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';

        $this->displayCard($username);

        if ($this->shop_thumbnail) {
            // Use shop thumbnail if available
            $this->thumbnail = $this->shop_thumbnail;
            $this->favicon = $this->shop_thumbnail;
        } else if ($this->user->thumbnail) {
            // User has a custom thumbnail
            $this->thumbnail = $this->user->thumbnail;
            $this->favicon = $this->user->thumbnail;
        } else if ($this->user->profile_pic) {
            // Use user's profile picture
            $this->thumbnail = $this->user->profile_pic;
            $this->favicon = $this->user->profile_pic;
        } else {
            // Default site thumbnail fallback
            $this->thumbnail = $this->thumbnail ?? null;
            $this->favicon = $this->thumbnail;
        }
    }

    public function render()
    {
        return view('livewire.display-product-collection')->title($this->product_collection->title . ' | ' . ($this->page_title ?: $this->card_title))->layoutData([
            'favicon' => $this->favicon,
            'thumbnail' => $this->thumbnail,
            'username' => $this->username,
            'site_url' => $this->site_url,
            'title' => $this->page_title ?: $this->card_title,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
            'app_name' => $this->app_name,
        ]);
    }
}
