<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\User;
use App\Models\Button;
use App\Models\Social;
use App\Models\SubCard;
use App\Settings\CardDefaultsSetting;
use App\Models\UserSettings;

class DownloadVcfButton extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;

    public $type;

    public $username;
    public $user;
    public $user_id;
    public $contacts;
    public $payments;
    public $products;
    public $videos;
    public $buttons;
    public $title;
    public $socials;
    public $video_count;

    // To display as SEO
    public $fullname;
    public $bio;
    public $favicon;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    public $imageData;

    //for VCF
    public $firstname, $lastname, $email, $phone, $gender, $customLinks, $job_title, $company, $company_website, $vbc, $profile_pic, $user_type;

    public $color_settings_custom_button;
    public $color_settings_custom_button_text;

    public $condition;
    public $query;

    //style
    public $button_style;

    public function generateVCF($username)
    {
        $this->username = $username;

        if ($this->mainCard) {
            $this->user = User::where('username', $this->username)->where('is_active', true)->first(['email', 'phone', 'profile_pic', 'username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'language', 'address', 'country', 'id', 'user_type']);
            $this->query = ['user_id' => $this->user->id, 'page_id' => NULL];
        } else {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.username', $this->username)
                ->first([
                    'subcards.id',
                    'subcards.user_id',
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'users.firstname',
                    'users.lastname',
                    'users.address',
                    'users.country',
                    'users.user_type',
                    'subcards.email',
                    'subcards.phone',
                    'users.id',
                ]);

            // $this->query = ['user_id' => $this->user->id, 'page_id' => $this->page_id];
            $this->query = ['page_id' => $this->page_id];
        }

        //  $this->buttons = $this->user->buttons()->where('is_active', true)->where('view', 'links')->orderBy('order')->get();

        // $this->socials = $this->user->socials()->where('is_active', true)->orderBy('order')->get();
        // $this->contacts = $this->user->buttons()->where('is_active', true)->where('view', 'contacts')->orderBy('order')->get();
        // $this->payments = $this->user->buttons()->where('is_active', true)->where('view', 'payments')->orderBy('order')->get();

        $this->buttons = Button::where($this->query)
            ->where('is_active', true)
            ->where('view', 'links')
            ->orderBy('order')->get();

        $this->socials = Social::where($this->query)
            ->where('is_active', true)
            ->orderBy('order')->get();

        $this->contacts = Button::where($this->query)
            ->where('is_active', true)
            ->where('view', 'contacts')
            ->orderBy('order')->get();

        $this->payments = Button::where($this->query)
            ->where('is_active', true)
            ->where('view', 'payments')
            ->orderBy('order')->get();

        $this->favicon = $this->user->profile_pic;
        $this->bio = $this->user->bio;
        $this->fullname = $this->user->firstname . ' ' . $this->user->lastname;

        $this->firstname = $this->user->firstname;
        $this->lastname = $this->user->lastname;
        $this->email = $this->user->email;
        $this->job_title = $this->user->job_title;
        $this->phone = $this->user->phone;
        $this->gender = $this->user->gender;
        $this->vbc = $this->site_url . $this->user->username;
        $this->company = $this->user->company;
        $this->company_website = $this->user->company_website;

        try {
            if (!$this->user) {
                throw new \Exception("User not found.");
            }

            // $customLinksString = '';
            // foreach ($this->buttons ?? [] as $link) {
            //     $customLinksString .= match ($link['type']) {
            //         'phone', 'sms' => "TEL;TYPE={$link['title']}:{$link['link']}\n",
            //         'email' => "EMAIL;TYPE={$link['title']}:{$link['link']}\n",
            //         default => "URL;TYPE={$link['title']}:{$link['link']}\n"
            //     };
            // }

            // $contactPointsString = '';
            // foreach ($this->contacts ?? [] as $contact) {
            //     $contactPointsString .= match ($contact['type']) {
            //         'phone', 'sms' => "TEL;TYPE={$contact['title']}:{$contact['link']}\n",
            //         'email' => "EMAIL;TYPE={$contact['title']}:{$contact['link']}\n",
            //         default => "URL;TYPE={$contact['title']}:{$contact['link']}\n"
            //     };
            // }

            // $socialLinksString = '';
            // foreach ($this->socials ?? [] as $social) {
            //     $socialLinksString .= "URL;TYPE=" . ucfirst($social['type']) . ":{$social['link']}\n";
            // }

            // $paymentLinksString = '';
            // foreach ($this->payments ?? [] as $payment) {
            //     $paymentLinksString .= "URL;TYPE=" . ucfirst($payment['type']) . ":{$payment['link']}\n";
            // }


            $customLinksString = '';
            $contactPointsString = '';
            $socialLinksString = '';
            $paymentLinksString = '';
            $seenLinks = [];

            // Avoid duplicating primary email and phone fields
            if (!empty($this->email)) {
                $seenLinks[trim($this->email)] = true;
            }

            if (!empty($this->phone)) {
                $seenLinks[trim($this->phone)] = true;
            }

            foreach ($this->buttons ?? [] as $link) {
                $linkValue = trim($link['link']);
                if (empty($linkValue) || isset($seenLinks[$linkValue])) continue;

                $seenLinks[$linkValue] = true;

                $customLinksString .= match ($link['type']) {
                    'phone', 'sms' => "TEL;TYPE={$link['title']}:{$linkValue}\n",
                    'email' => "EMAIL;TYPE={$link['title']}:{$linkValue}\n",
                    default => "URL;TYPE={$link['title']}:{$linkValue}\n"
                };
            }

            foreach ($this->contacts ?? [] as $contact) {
                $linkValue = trim($contact['link']);
                if (empty($linkValue) || isset($seenLinks[$linkValue])) continue;

                $seenLinks[$linkValue] = true;

                $contactPointsString .= match ($contact['type']) {
                    'phone', 'sms' => "TEL;TYPE={$contact['title']}:{$linkValue}\n",
                    'email' => "EMAIL;TYPE={$contact['title']}:{$linkValue}\n",
                    default => "URL;TYPE={$contact['title']}:{$linkValue}\n"
                };
            }

            foreach ($this->socials ?? [] as $social) {
                $linkValue = trim($social['link']);
                if (empty($linkValue) || isset($seenLinks[$linkValue])) continue;

                $seenLinks[$linkValue] = true;

                $socialLinksString .= "URL;TYPE=" . ucfirst($social['type']) . ":{$linkValue}\n";
            }

            foreach ($this->payments ?? [] as $payment) {
                $linkValue = trim($payment['link']);
                if (empty($linkValue) || isset($seenLinks[$linkValue])) continue;

                $seenLinks[$linkValue] = true;

                $paymentLinksString .= "URL;TYPE=" . ucfirst($payment['type']) . ":{$linkValue}\n";
            }

            $imageBlock = '';
            if ($this->favicon) {
                $imagePath = public_path($this->favicon);
                if (file_exists($imagePath)) {
                    $mimeType = mime_content_type($imagePath);
                    $type = strtoupper(explode('/', $mimeType)[1]);
                    $encoded = chunk_split(base64_encode(file_get_contents($imagePath)), 75, "\n ");
                    $imageBlock = "PHOTO;ENCODING=BASE64;TYPE={$type}:\n {$encoded}";
                }
            }

            $vcfData = <<<VCF
BEGIN:VCARD
VERSION:3.0
FN:{$this->firstname} {$this->lastname}
N:{$this->lastname};{$this->firstname};;;
TEL:{$this->phone}
TITLE:{$this->job_title}
ORG:{$this->company}
URL;TYPE=Company Website:{$this->company_website}
URL;TYPE=Video Business Card:{$this->vbc}
{$customLinksString}{$socialLinksString}{$contactPointsString}{$paymentLinksString}{$imageBlock}
END:VCARD
VCF;

            $tempFile = tempnam(sys_get_temp_dir(), 'vcf_') . '.vcf';
            file_put_contents($tempFile, $vcfData);

            return response()->download($tempFile, "{$this->firstname}_{$this->lastname}_contact.vcf", [
                'Content-Type' => 'text/vcard',
                'Content-Disposition' => 'inline; filename="contact.vcf"',
            ])->deleteFileAfterSend(true);
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'An error occurred while generating the vCard: ' . $e->getMessage()
            ], 500);
        }
    }

    public function __construct()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
    }

    public function mount($username)
    {
        $this->checkMain = User::where('username', $username)->count();
        $this->checkSub = SubCard::where('username', $username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();
            $this->condition = ['user_id' => $this->user_id, 'page_id' => NULL];
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('username', $username)
                ->pluck('id')
                ->first();
            $this->mainCard = false;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();

            $this->user_id = SubCard::where('username', $username)
                ->pluck('user_id')
                ->first();

            // $this->condition = ['user_id' => $this->user_id, 'page_id' => $this->page_id];
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->button_style = UserSettings::where('setting_key', 'button_style')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // dd($this->color_settings_custom_button, $this->color_settings_custom_button_text, $this->condition);
        //style
        $this->button_style = $this->button_style ?: 'rounded';
        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
    }

    public function render()
    {
        return view('livewire.download-vcf-button');
    }
}
