<?php

namespace App\Livewire;

use App\Models\SubCard;
use App\Models\User;
use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use App\Models\UserSettings;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class EditFreeAds extends Component
{
    // use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $app_name;

    public $thumbnail;
    public $default_ads_enabled;
    public $default_ads;
    public $ad_items;

    public $ads;
    public $user_type;

    public $user;

    public $page_id; //subcard id, used in query
    public $condition;

    public function saveLinks()
    {
        // dd($this->ads);
        if (!$this->ads || !is_array($this->ads)) {
            return;
        }

        foreach ($this->ads as $index => $data) {

            // skip if ad is inactive (user can't edit it)
            if (empty($this->ad_items[$index]['is_active'])) {
                continue;
            }

            $settingKey = "ads.$index.user_link";

            UserSettings::updateOrCreate(
                [
                    'user_id'  => auth()->id(),
                    'page_id'  => $this->page_id,
                    'setting_key' => $settingKey,
                ],
                [
                    'setting_value' => $data['user_link'] ?? null,
                ]
            );
        }

        session()->flash('success', 'Ad links updated successfully!');
        return $this->redirectRoute('dashboard.freeads');
    }


    public function mount()
    {
        $default = app(CardDefaultsSetting::class);

        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;
        $this->default_ads_enabled = $default->default_ads_enabled;
        $this->ad_items = $default->ad_items;

        if ($this->default_ads_enabled == false) {
            abort(403, 'Access denied');
        }

        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        // if active, get the datas and set to form
        if ($checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {

            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }

        $this->default_ads = UserSettings::where('setting_key', 'like', 'ads.%')
            ->where($this->condition)
            ->pluck('setting_value', 'setting_key')
            ->toArray();

        $this->user_type = auth()->user()->user_type;

        // Initialize ads array for the form AFTER default_ads is loaded
        $this->ads = [];

        foreach ($this->ad_items as $index => $item) {
            $settingKey = "ads.$index.user_link";

            $this->ads[$index]['user_link'] = $this->default_ads[$settingKey] ?? '';
        }
    }


    public function render()
    {
        // $this->authorize('view', Ad::class);
        // dd($this->default_ads);
        return view('livewire.edit-free-ads')
            ->title('Ads Management | ' . $this->site_name)->layoutData([
                'thumbnail' => $this->thumbnail,
                'app_name' => $this->app_name,
            ]);
    }
}
