<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Product;
use App\Models\ProductMedia;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Storage;
use App\Models\UserSettings;

class EditProductImage extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $image;

    public $new_image, $old_image, $path;
    public $condition, $checkifactive, $page_id;

    public $color_settings_profile_pic_border;
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    public $id, $product_id, $check_if_product_is_from_user;

    #[On('galleryImage')]
    public function setImage($newImageUrl)
    {
        $this->new_image = new TemporaryUploadedFile($newImageUrl, config('filesystems.default'));
    }

    public function updateImage()
    {
        if ($this->new_image) {
            // Delete the old image if it exists
            if ($this->old_image && Storage::disk('public')->exists($this->old_image)) {
                Storage::disk('public')->delete($this->old_image);
            }

            // Store the new image
            $validated['path'] = $this->new_image->storePublicly('products', 'public');

            // Delete temp file if still there (optional, Laravel usually cleans this up)
            $tempFilePath = $this->new_image->getRealPath();
            if (file_exists($tempFilePath)) {
                unlink($tempFilePath);
            }
        }

        // Update the user's image
        $update = ProductMedia::where('id', $this->id)->update($validated);

        if ($update) {
            session()->flash('success', 'Product gallery image successfully updated!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/product/edit/' . $this->product_id, navigate: true);
    }

    public function viewImage($id)
    {
        $this->image = ProductMedia::where('id', $id)
            ->first();
    }

    public function mount($product_id, $id)
    {
        $this->id = $id;
        $this->product_id = $product_id;

        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive < 1) {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        } else {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        }

        $this->check_if_product_is_from_user = Product::where('id', $product_id)
            ->where($this->condition)->count();

        // Load existing video links
        $this->path = ProductMedia::where('id', $this->id)
            ->pluck('path')
            ->first();

        // 🧠 If no match found (invalid id or not owned by user)
        if (!$this->path) {
            abort(403, 'Access denied');
        }

        $this->viewImage($this->id);

        $this->old_image = $this->image->path;

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->dispatch('setEditImage', $this->old_image);

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Text Color Settings
        $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';

        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';

        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
        $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
        $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
        $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';
    }

    public function render()
    {
        // $this->authorize('update', Image::class);
        return view('livewire.edit-product-image')->title('Update Product Image | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
            'color_settings_profile_pic_border' => $this->color_settings_profile_pic_border,
            'color_settings_custom_button_text' => $this->color_settings_custom_button_text,
            'color_settings_custom_button' => $this->color_settings_custom_button,
            'app_name' => $this->app_name,
        ]);
    }
}
