<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\User;
use App\Models\SubCard;
use App\Models\Replay;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use Illuminate\Validation\ValidationException;

class EditZoomReplay extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $zoom, $title, $link;
    public $zoom_id;
    public $condition, $page_id;

    public function updateZoomLink()
    {
        try {
            $validated = $this->validate([
                'title' => 'required|string',
                'link' => 'required|url',
            ]);

            $update = Replay::where('id', $this->zoom_id)->update($validated);

            if ($update) {
                session()->flash('success', 'Zoom link successfully updated!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }

            return $this->redirect('/dashboard/replays', navigate: true);
        } catch (ValidationException $e) {
            // stop spinner on validation errors
            $this->dispatch('set-submitting', ['value' => false]);
            throw $e;
        }
    }

    public function viewZoom($id)
    {
        $this->zoom = Replay::where($this->condition)
            ->where('id', $id)
            ->select('id', 'title', 'link')
            ->first();

        if (!$this->zoom) {
            abort(403, 'Access denied');
        }
    }

    public function mount($id)
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }

        $this->zoom_id = $id;
        $this->viewZoom($this->zoom_id);
        $this->title = $this->zoom->title;
        $this->link = $this->zoom->link;
    }

    public function render()
    {
        // $this->authorize('update', Product::class);
        return view('livewire.edit-zoom-replay')->title('Edit Zoom Replay | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
