<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Attributes\Validate;
use Livewire\Attributes\On;
use Illuminate\Database\Eloquent\Model;

class EventImageField extends Component
{
    use WithFileUploads;

    public Model $model;
    public $title = 'Event Poster';
    public $image;
    public ?string $croppedBlob;
    public $event_image;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]

    #[On('setEventImage')]
    public function setEventImage($croppedBlob)
    {
        $this->croppedBlob = $croppedBlob;
        // dd('Triggered set event image');
    }

    #[On('setEditEventImage')]
    public function setEventImageEdit($event_image)
    {
        $this->event_image = $event_image;
    }

    public function mount($title = null)
    {
        if ($title) {
            $this->title = $title;
        }
    }

    public function render()
    {
        return view('livewire.event-image-field');
    }
}
